/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.core.CandidateElement;
import com.crawljax.forms.FormInput;
import com.crawljax.util.DomUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CandidateElementTest {
    private static Document document;
    private final List<FormInput> noFormInput = ImmutableList.of();
    private CandidateElement c;
    private Element e;

    @BeforeClass
    public static void setupOnce() throws IOException {
        document = DomUtils.asDocument((String)"");
    }

    @Before
    public void setup() {
        this.e = document.createElement("test");
        this.c = new CandidateElement(this.e, "", this.noFormInput);
    }

    @Test
    public void testEmptyElement() {
        Assert.assertEquals((String)"General String and Unique String are the same", (Object)this.c.getGeneralString(), (Object)this.c.getUniqueString());
        Assert.assertEquals((String)"Expected result", (Object)"TEST:  xpath", (Object)this.c.getGeneralString().trim());
    }

    @Test
    public void testOneAttributeElement() {
        this.e.setAttribute("id", "abc");
        Assert.assertEquals((String)"General String and Unique String are the same", (Object)this.c.getGeneralString(), (Object)this.c.getUniqueString());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: id=abc xpath", (Object)this.c.getGeneralString().trim());
    }

    @Test
    public void testTwoAttributeElement() {
        this.e.setAttribute("id", "abc");
        this.e.setAttribute("class", "def");
        Assert.assertEquals((String)"General String and Unique String are the same", (Object)this.c.getGeneralString(), (Object)this.c.getUniqueString());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: class=def id=abc xpath", (Object)this.c.getGeneralString().trim());
    }

    @Test
    public void testOneAttributeElementWithAtusa() {
        this.e.setAttribute("id", "abc");
        this.e.setAttribute("atusa", "ignore");
        Assert.assertNotSame((String)"General String and Unique String are not the same", (Object)this.c.getGeneralString(), (Object)this.c.getUniqueString());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: id=abc xpath", (Object)this.c.getGeneralString().trim());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: atusa=ignore id=abc xpath", (Object)this.c.getUniqueString().trim());
    }

    @Test
    public void testTwoAttributeElementWithAtusa() {
        this.e.setAttribute("id", "abc");
        this.e.setAttribute("atusa", "ignore");
        this.e.setAttribute("class", "def");
        Assert.assertNotSame((String)"General String and Unique String are not the same", (Object)this.c.getGeneralString(), (Object)this.c.getUniqueString());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: class=def id=abc xpath", (Object)this.c.getGeneralString().trim());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: atusa=ignore class=def id=abc xpath", (Object)this.c.getUniqueString().trim());
    }

    @Test
    public void testMultipleAttributeElementWithAtusaOrderedAlphabetical() {
        this.e.setAttribute("id", "abc");
        this.e.setAttribute("atusa", "ignore");
        this.e.setAttribute("class", "def");
        this.e.setAttribute("z", "z");
        this.e.setAttribute("a", "a");
        this.e.setAttribute("x", "a");
        Assert.assertNotSame((String)"General String and Unique String are not the same", (Object)this.c.getGeneralString(), (Object)this.c.getUniqueString());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: a=a class=def id=abc x=a z=z xpath", (Object)this.c.getGeneralString().trim());
        Assert.assertEquals((String)"Expected result", (Object)"TEST: a=a atusa=ignore class=def id=abc x=a z=z xpath", (Object)this.c.getUniqueString().trim());
    }
}

