/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.codahale.metrics.MetricRegistry;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.CandidateCrawlAction;
import com.crawljax.core.CrawlController;
import com.crawljax.core.CrawlTaskConsumer;
import com.crawljax.core.Crawler;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.UnfiredFragmentCandidates;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.plugin.PostCrawlingPlugin;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.di.CrawlSessionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CrawlControllerTest {
    @Mock
    private InMemoryStateFlowGraph graph;
    @Mock
    private Provider<StateFlowGraph> graphProvider;
    private UnfiredFragmentCandidates candidateActions;
    private ExitNotifier consumersDoneLatch;
    @Mock
    private Crawler crawler;
    @Mock
    private Provider<CrawlTaskConsumer> consumerFactory;
    private CrawlSessionProvider crawlSessionProvider;
    private CrawlController controller;
    @Mock
    private StateVertex index;
    @Mock
    private StateVertex state3;
    @Mock
    private StateVertex state2;
    private AtomicInteger polledActions;
    @Mock
    private PostCrawlingPlugin postCrawlPlugin;
    @Mock
    private CrawlerContext crawlerContext;
    private CrawljaxConfiguration config;

    @Before
    public void setup() {
        this.config = CrawljaxConfiguration.builderFor((String)"http://example.com").build();
        this.setupGraphAndStates();
        this.polledActions = new AtomicInteger();
        ((Crawler)Mockito.doAnswer(invocation -> {
            StateVertex task = (StateVertex)invocation.getArguments()[0];
            CandidateCrawlAction action = this.candidateActions.pollActionOrNull(task);
            while (action != null) {
                Thread.sleep(25L);
                this.polledActions.incrementAndGet();
                action = this.candidateActions.pollActionOrNull(task);
            }
            return null;
        }).when((Object)this.crawler)).execute((StateVertex)ArgumentMatchers.any(StateVertex.class));
        ((Crawler)Mockito.doReturn((Object)this.crawlerContext).when((Object)this.crawler)).getContext();
    }

    private void setupGraphAndStates() {
        Mockito.when((Object)((StateFlowGraph)this.graphProvider.get())).thenReturn((Object)this.graph);
        Mockito.when((Object)this.index.getId()).thenReturn((Object)1);
        Mockito.when((Object)this.graph.getById(1)).thenReturn((Object)this.index);
        Mockito.when((Object)this.crawler.crawlIndex()).thenReturn((Object)this.index);
        Mockito.when((Object)this.crawler.getCrawlRules()).thenReturn((Object)this.config.getCrawlRules());
        Mockito.when((Object)this.state2.getId()).thenReturn((Object)2);
        Mockito.when((Object)this.state3.getId()).thenReturn((Object)3);
        Mockito.when((Object)this.graph.getById(2)).thenReturn((Object)this.state2);
        Mockito.when((Object)this.graph.getById(3)).thenReturn((Object)this.state3);
        this.setNames(this.index, this.state2, this.state3);
    }

    private void setNames(StateVertex ... state) {
        for (StateVertex stateVertex : state) {
            String name = "State-" + stateVertex.getId();
            Mockito.when((Object)stateVertex.getName()).thenReturn((Object)name);
        }
    }

    private void setupForConsumers(int consumers) {
        ExecutorService executor = Executors.newFixedThreadPool(consumers + 2);
        this.config = CrawljaxConfiguration.builderFor((String)"http://example.com").addPlugin(new Plugin[]{this.postCrawlPlugin}).setBrowserConfig(new BrowserConfiguration(EmbeddedBrowser.BrowserType.FIREFOX, consumers)).build();
        this.candidateActions = new UnfiredFragmentCandidates(this.config.getBrowserConfig(), this.graphProvider, new MetricRegistry(), this.config.getCrawlRules());
        this.consumersDoneLatch = new ExitNotifier(this.config.getMaximumStates());
        Mockito.when((Object)((CrawlTaskConsumer)this.consumerFactory.get())).thenReturn((Object)new CrawlTaskConsumer(this.candidateActions, this.consumersDoneLatch, this.crawler));
        this.crawlSessionProvider = new CrawlSessionProvider(this.graph, this.config, new MetricRegistry());
        Plugins plugins = new Plugins(this.config, new MetricRegistry());
        this.controller = new CrawlController(executor, this.consumerFactory, this.config, this.consumersDoneLatch, this.crawlSessionProvider, plugins);
    }

    @Test(timeout=5000L)
    public void withASingleTaskTheCrawlerTerminates() {
        this.setupForConsumers(1);
        this.runWithOneTask();
    }

    @Test(timeout=5000L)
    public void withASingleTaskMultipleConsumersTheCrawlerTerminates() {
        this.setupForConsumers(4);
        this.runWithOneTask();
    }

    private void runWithOneTask() {
        this.candidateActions.addActions(this.mockActions(1), this.index);
        this.controller.call();
        MatcherAssert.assertThat((Object)this.polledActions.get(), (Matcher)Is.is((Object)1));
    }

    @Test(timeout=5000L)
    public void withSixTasksTheCrawlerTerminates() {
        this.setupForConsumers(1);
        this.candidateActions.addActions(this.mockActions(2), this.index);
        this.candidateActions.addActions(this.mockActions(2), this.state2);
        this.candidateActions.addActions(this.mockActions(2), this.state3);
        this.controller.call();
        MatcherAssert.assertThat((Object)this.polledActions.get(), (Matcher)Is.is((Object)6));
    }

    @Test(timeout=50000L)
    public void withManyActionsMultipleConsumersTheCrawlerTerminates() {
        this.setupForConsumers(4);
        this.runWith300Actions();
        ((Crawler)Mockito.verify((Object)this.crawler, (VerificationMode)Mockito.times((int)4))).close();
    }

    private void runWith300Actions() {
        this.candidateActions.addActions(this.mockActions(200), this.index);
        this.candidateActions.addActions(this.mockActions(200), this.state2);
        this.candidateActions.addActions(this.mockActions(200), this.state3);
        this.controller.call();
        MatcherAssert.assertThat((Object)this.polledActions.get(), (Matcher)Is.is((Object)600));
    }

    public List<CandidateCrawlAction> mockActions(int size) {
        ArrayList<CandidateCrawlAction> list = new ArrayList<CandidateCrawlAction>(size);
        for (int i = 0; i < size; ++i) {
            CandidateCrawlAction action = (CandidateCrawlAction)Mockito.mock(CandidateCrawlAction.class);
            list.add(action);
        }
        return list;
    }

    @After
    public void verifyPerfectEndState() {
        MatcherAssert.assertThat((Object)this.candidateActions.isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.consumersDoneLatch.isExitCalled(), (Matcher)Is.is((Object)true));
        ((PostCrawlingPlugin)Mockito.verify((Object)this.postCrawlPlugin)).postCrawling(this.crawlSessionProvider.get(), ExitNotifier.ExitStatus.EXHAUSTED);
    }
}

