/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.OnNewStatePlugin;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.state.StateVertex;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class CrawlerStopTest {
    @ClassRule
    public static final RunWithWebServer SERVER = new RunWithWebServer("/site");

    @Test
    public void maximumDepthIsObliged() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("infinite.html");
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        int depth = 3;
        CrawljaxRunner runner = new CrawljaxRunner(builder.setMaximumDepth(depth).build());
        CrawlSession session = runner.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(depth + 1));
        MatcherAssert.assertThat((Object)runner.getReason(), (Matcher)Is.is((Object)ExitNotifier.ExitStatus.EXHAUSTED));
    }

    @Test(timeout=60000L)
    public void maximumTimeIsObliged() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("infinite.html");
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        CrawljaxRunner runner = new CrawljaxRunner(builder.setUnlimitedCrawlDepth().setMaximumRunTime(25L, TimeUnit.SECONDS).build());
        runner.call();
        MatcherAssert.assertThat((Object)runner.getReason(), (Matcher)Is.is((Object)ExitNotifier.ExitStatus.MAX_TIME));
    }

    @Test(timeout=60000L)
    public void maximumStatesIsObliged() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("infinite.html");
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        CrawljaxRunner runner = new CrawljaxRunner(builder.setUnlimitedCrawlDepth().setMaximumStates(3).build());
        CrawlSession session = runner.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(3));
        MatcherAssert.assertThat((Object)runner.getReason(), (Matcher)Is.is((Object)ExitNotifier.ExitStatus.MAX_STATES));
    }

    @Test(timeout=60000L)
    public void whenStopIsCalledTheCrawlerStopsGracefully() throws Exception {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("infinite.html");
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        CrawljaxRunner runner = new CrawljaxRunner(builder.setUnlimitedCrawlDepth().setUnlimitedCrawlDepth().setUnlimitedStates().build());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(runner);
        Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
        runner.stop();
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)runner.getReason(), (Matcher)Is.is((Object)ExitNotifier.ExitStatus.STOPPED));
    }

    @Test(timeout=60000L)
    public void whenCrawljaxIsShutDownByAPluginItShutsDown() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("infinite.html");
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        CrawljaxRunner runner = new CrawljaxRunner(builder.setUnlimitedCrawlDepth().addPlugin(new Plugin[]{new OnNewStatePlugin(){
            private int count = 0;

            public void onNewState(CrawlerContext context, StateVertex newState) {
                if (this.count == 2) {
                    context.stop();
                }
                ++this.count;
            }

            public String toString() {
                return "Stop crawljax plugin";
            }
        }}).setUnlimitedCrawlDepth().setUnlimitedStates().build());
        CrawlSession session = runner.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(3));
        MatcherAssert.assertThat((Object)runner.getReason(), (Matcher)Is.is((Object)ExitNotifier.ExitStatus.STOPPED));
    }
}

