/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.codahale.metrics.MetricRegistry;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.browserwaiter.WaitConditionChecker;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CandidateElementExtractor;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.Crawler;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.UnfiredFragmentCandidates;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.state.DefaultStateVertexFactory;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateMachine;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexFactory;
import com.crawljax.di.CoreModule;
import com.crawljax.forms.FormHandler;
import com.crawljax.forms.FormInput;
import com.crawljax.forms.TrainingFormHandler;
import com.crawljax.oraclecomparator.StateComparator;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Provider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class CrawlerTest {
    private URI url;
    private String strippedDom;
    private Crawler crawler;
    private StateMachine sm;
    @Mock
    private EmbeddedBrowser browser;
    @Spy
    private Plugins plugins = new Plugins(CrawljaxConfiguration.builderFor((String)"http://localhost").build(), new MetricRegistry());
    @Mock
    private Provider<CrawlSession> sessionProvider;
    @Mock
    private CrawlSession session;
    private StateComparator stateComparator;
    @Mock
    private FormHandler formHandler;
    @Mock
    private TrainingFormHandler trainingFormHandler;
    @Mock
    private WaitConditionChecker waitConditionChecker;
    @Mock
    private CandidateElementExtractor extractor;
    @Mock
    private UnfiredFragmentCandidates candidateActionCache;
    @Mock
    private StateVertex index;
    @Mock
    private StateVertex target;
    @Mock
    private InMemoryStateFlowGraph graph;
    @Mock
    private Provider<InMemoryStateFlowGraph> graphProvider;
    @Mock
    private Eventable eventToTransferToTarget;
    @Captor
    private ArgumentCaptor<List<FormInput>> formInputsCaptor;
    @Mock
    private CandidateElement action;
    @Mock
    private ExitNotifier exitNotifier;
    private CrawlerContext context;

    @Before
    public void setup() {
        CoreModule.CandidateElementExtractorFactory elementExtractor = (CoreModule.CandidateElementExtractorFactory)Mockito.mock(CoreModule.CandidateElementExtractorFactory.class);
        Mockito.when((Object)elementExtractor.newExtractor(this.browser)).thenReturn((Object)this.extractor);
        CoreModule.FormHandlerFactory formHandlerFactory = (CoreModule.FormHandlerFactory)Mockito.mock(CoreModule.FormHandlerFactory.class);
        Mockito.when((Object)formHandlerFactory.newFormHandler(this.browser)).thenReturn((Object)this.formHandler);
        CoreModule.TrainingFormHandlerFactory trainingFormHandlerFactory = (CoreModule.TrainingFormHandlerFactory)Mockito.mock(CoreModule.TrainingFormHandlerFactory.class);
        Mockito.when((Object)trainingFormHandlerFactory.newTrainingFormHandler(this.browser)).thenReturn((Object)this.trainingFormHandler);
        this.url = URI.create("http://example.com");
        this.strippedDom = "<html><body><p>Hello</p></body></html>";
        Mockito.when((Object)this.browser.getCurrentUrl()).thenReturn((Object)this.url.toString());
        Mockito.when((Object)this.browser.getStrippedDom()).thenReturn((Object)this.strippedDom);
        Mockito.when((Object)((CrawlSession)this.sessionProvider.get())).thenReturn((Object)this.session);
        CrawljaxConfiguration config = (CrawljaxConfiguration)Mockito.spy((Object)CrawljaxConfiguration.builderFor((URI)this.url).build());
        this.stateComparator = new StateComparator(config.getCrawlRules());
        Mockito.when((Object)this.extractor.extract(this.target)).thenReturn((Object)ImmutableList.of((Object)this.action));
        Mockito.when((Object)((InMemoryStateFlowGraph)this.graphProvider.get())).thenReturn((Object)this.graph);
        this.context = new CrawlerContext(this.browser, config, this.sessionProvider, this.exitNotifier, new MetricRegistry());
        this.crawler = new Crawler(this.context, config, this.stateComparator, this.candidateActionCache, formHandlerFactory, null, this.waitConditionChecker, elementExtractor, this.graphProvider, this.plugins, (StateVertexFactory)new DefaultStateVertexFactory());
        Mockito.when((Object)this.candidateActionCache.pollActionOrNull(this.index)).thenReturn(null);
        Mockito.when((Object)this.candidateActionCache.getInput((Eventable)Mockito.any())).thenReturn(null);
        this.setupStateFlowGraph();
        this.setStateMachineForConfig(config);
        this.crawler.setStateMachine(this.sm);
    }

    private void setupStateFlowGraph() {
        Mockito.when((Object)this.index.getId()).thenReturn((Object)1);
        Mockito.when((Object)this.index.getName()).thenReturn((Object)"Index");
        Mockito.when((Object)this.index.toString()).thenReturn((Object)"index");
        Mockito.when((Object)this.target.getId()).thenReturn((Object)2);
        Mockito.when((Object)this.target.getName()).thenReturn((Object)"State 2");
        Mockito.when((Object)this.target.toString()).thenReturn((Object)"target");
        Mockito.when((Object)this.eventToTransferToTarget.getIdentification()).thenReturn((Object)new Identification(Identification.How.name, "//DIV[@id='click]"));
        Mockito.when((Object)this.eventToTransferToTarget.getRelatedFrame()).thenReturn((Object)"");
        Mockito.when((Object)this.eventToTransferToTarget.getSourceStateVertex()).thenReturn((Object)this.index);
        Mockito.when((Object)this.eventToTransferToTarget.getTargetStateVertex()).thenReturn((Object)this.target);
        Mockito.when((Object)this.eventToTransferToTarget.getRelatedFormInputs()).thenReturn((Object)ImmutableList.copyOf(new CopyOnWriteArrayList()));
        Mockito.when((Object)this.graph.getShortestPath(this.index, this.target)).thenReturn((Object)ImmutableList.of((Object)this.eventToTransferToTarget));
        Mockito.when((Object)this.graph.getInitialState()).thenReturn((Object)this.index);
        Mockito.when((Object)this.session.getStateFlowGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.session.getInitialState()).thenReturn((Object)this.index);
        Mockito.when((Object)this.graph.canGoTo(this.index, this.target)).thenReturn((Object)true);
        Mockito.when((Object)this.graph.putIfAbsent(this.index)).thenReturn((Object)this.index);
        Mockito.when((Object)this.graph.newStateFor((String)Mockito.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (EmbeddedBrowser)Mockito.any())).thenReturn((Object)this.index, (Object[])new StateVertex[]{this.index, this.index, this.index, this.target});
    }

    private void setStateMachineForConfig(CrawljaxConfiguration config) {
        ArrayList<StateVertex> onURLSet = new ArrayList<StateVertex>();
        onURLSet.add(this.index);
        this.sm = new StateMachine(this.graph, config.getCrawlRules().getInvariants(), this.plugins, null, onURLSet);
    }

    @Test
    public void whenResetTheStateIsBackToIndex() {
        this.crawler.reset(0);
        this.verifyCrawlerReset(Mockito.inOrder((Object[])new Object[]{this.plugins, this.browser}));
    }

    private void verifyCrawlerReset(InOrder order) {
        ((EmbeddedBrowser)order.verify((Object)this.browser)).goToUrl(this.url);
        ((Plugins)order.verify((Object)this.plugins)).runOnUrlLoadPlugins(this.context);
    }

    @Test
    public void whenExecuteTaskTheCrawlIsCompletedCorrectly() throws Exception {
        Mockito.when((Object)this.extractor.checkCrawlCondition()).thenReturn((Object)true);
        Mockito.when((Object)this.browser.fireEventAndWait(this.eventToTransferToTarget)).thenReturn((Object)true);
        this.crawler.execute(this.target);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.extractor, this.browser, this.formHandler, this.plugins, this.waitConditionChecker, this.candidateActionCache});
        this.verifyPathIsFollowed(order);
    }

    private void verifyPathIsFollowed(InOrder order) {
        this.verifyCrawlerReset(order);
        ((CandidateElementExtractor)order.verify((Object)this.extractor)).checkCrawlCondition();
        this.verifyFormElementsChecked(order);
        ((WaitConditionChecker)order.verify((Object)this.waitConditionChecker)).wait(this.browser);
        ((EmbeddedBrowser)order.verify((Object)this.browser)).closeOtherWindows();
        ((Plugins)order.verify((Object)this.plugins)).runOnRevisitStatePlugins(this.context, this.target);
        ((CandidateElementExtractor)order.verify((Object)this.extractor)).checkCrawlCondition();
        ((UnfiredFragmentCandidates)order.verify((Object)this.candidateActionCache)).pollActionOrNull(this.target);
    }

    private void verifyFormElementsChecked(InOrder order) {
        ((FormHandler)order.verify((Object)this.formHandler)).getFormInputs();
        ((FormHandler)order.verify((Object)this.formHandler)).handleFormElements((List)this.formInputsCaptor.capture());
        ((List)this.formInputsCaptor.getValue()).isEmpty();
    }
}

