/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import java.util.concurrent.TimeUnit;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class IFrameTest {
    @ClassRule
    public static final RunWithWebServer WEB_SERVER = new RunWithWebServer("/site");
    protected CrawljaxRunner crawljax;

    protected CrawljaxConfiguration.CrawljaxConfigurationBuilder setupConfig() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = WEB_SERVER.newConfigBuilder("iframe");
        builder.setBrowserConfig(new BrowserConfiguration(EmbeddedBrowser.BrowserType.FIREFOX_HEADLESS));
        builder.crawlRules().waitAfterEvent(100L, TimeUnit.MILLISECONDS);
        builder.crawlRules().waitAfterReloadUrl(100L, TimeUnit.MILLISECONDS);
        builder.setMaximumDepth(3);
        builder.crawlRules().click("a");
        builder.crawlRules().click("input");
        return builder;
    }

    @Test
    public void testIFrameCrawlable() throws CrawljaxException {
        this.crawljax = new CrawljaxRunner(this.setupConfig().build());
        CrawlSession session = this.crawljax.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasEdges(23));
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(13));
    }

    @Test
    public void testIframeExclusions() throws CrawljaxException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = this.setupConfig();
        builder.crawlRules().dontCrawlFrame("frame1");
        builder.crawlRules().dontCrawlFrame("sub");
        builder.crawlRules().dontCrawlFrame("frame0");
        CrawljaxConfiguration config = builder.build();
        this.crawljax = new CrawljaxRunner(config);
        CrawlSession session = this.crawljax.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasEdges(5));
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(4));
    }

    @Test
    public void testIFramesNotCrawled() throws CrawljaxException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = this.setupConfig();
        builder.crawlRules().crawlFrames(false);
        this.crawljax = new CrawljaxRunner(builder.build());
        CrawlSession session = this.crawljax.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasEdges(5));
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(4));
    }

    @Test
    public void testIFramesWildcardsNotCrawled() throws CrawljaxException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = this.setupConfig();
        builder.crawlRules().dontCrawlFrame("frame%");
        builder.crawlRules().dontCrawlFrame("sub");
        this.crawljax = new CrawljaxRunner(builder.build());
        CrawlSession session = this.crawljax.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasEdges(5));
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(4));
    }

    @Test
    public void testCrawlingOnlySubFrames() throws CrawljaxException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = this.setupConfig();
        builder.crawlRules().dontCrawlFrame("frame1.frame10");
        this.crawljax = new CrawljaxRunner(builder.build());
        CrawlSession session = this.crawljax.call();
        Assert.assertEquals((String)"Clickables", (long)21L, (long)session.getStateFlowGraph().getAllEdges().size());
        Assert.assertEquals((String)"States", (long)12L, (long)session.getStateFlowGraph().getAllStates().size());
    }
}

