/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.test.BrowserTest;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class PassBasicHttpAuthTest {
    private static final String USERNAME = "test";
    private static final String PASSWORD = "test#&";
    private static final String USER_ROLE = "user";
    private Server server;
    private int port;

    @Before
    public void setup() throws Exception {
        this.server = new Server(0);
        ResourceHandler handler = new ResourceHandler();
        handler.setBaseResource(Resource.newClassPathResource((String)"/site"));
        ConstraintSecurityHandler csh = this.newSecurityHandler(handler);
        this.server.setHandler((Handler)csh);
        this.server.start();
        this.port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    private ConstraintSecurityHandler newSecurityHandler(ResourceHandler handler) {
        HashLoginService login = new HashLoginService();
        login.setConfig(PassBasicHttpAuthTest.class.getResource("/realm.properties").getPath());
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{USER_ROLE});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.addConstraintMapping(cm);
        csh.setLoginService((LoginService)login);
        csh.setHandler((Handler)handler);
        return csh;
    }

    @Test
    public void testProvidedCredentialsAreUsedInBasicAuth() {
        String url = "http://localhost:" + this.port + "/infinite.html";
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((String)url);
        builder.setMaximumStates(3);
        builder.setBasicAuth(USERNAME, PASSWORD);
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        CrawlSession session = new CrawljaxRunner(builder.build()).call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(3));
    }

    @After
    public void shutDown() throws Exception {
        this.server.stop();
    }
}

