/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.core.configuration.CrawlActionsBuilder;
import com.crawljax.core.configuration.CrawlElementMatcher;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;

public class CrawlActionsTest {
    private CrawlActionsBuilder actions;

    @Before
    public void setup() {
        this.actions = new CrawlActionsBuilder();
    }

    @Test
    public void testIncludesWork() {
        this.actions.click("a");
        this.actions.click("b").underXPath("123");
        this.actions.click("b").underXPath("sdfsdf");
        List crawlElements = (List)this.actions.build().getLeft();
        MatcherAssert.assertThat((Object)crawlElements, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    public void testExcludesWork() {
        this.actions.dontClick("a");
        this.actions.dontClick("b").underXPath("123");
        this.actions.dontClick("b").underXPath("sdfsdf");
        List crawlElements = (List)this.actions.build().getRight();
        MatcherAssert.assertThat((Object)crawlElements, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    @Test
    public void testExcludeParents() {
        this.actions.click("a");
        this.actions.click("button");
        this.actions.dontClickChildrenOf("b").withId("someId");
        this.actions.dontClickChildrenOf("b").withClass("someClass");
        List crawlElements = (List)this.actions.build().getRight();
        MatcherAssert.assertThat((Object)crawlElements, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MatcherAssert.assertThat((Object)crawlElements, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CrawlElementMatcher.withXpath("//B[@id='someId']//*"), CrawlElementMatcher.withXpath("//B[@id='someId']//*"), CrawlElementMatcher.withXpath("//B[@class='someClass']//*"), CrawlElementMatcher.withXpath("//B[@class='someClass']//*")}));
    }
}

