/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.core.configuration.CrawlScope;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.configuration.DefaultCrawlScope;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;

public class CrawljaxConfigurationBuilderTest {
    @Test(expected=IllegalArgumentException.class)
    public void negativeMaximumStatesIsNotAllowed() {
        this.testBuilder().setMaximumStates(-1).build();
    }

    private CrawljaxConfiguration.CrawljaxConfigurationBuilder testBuilder() {
        return CrawljaxConfiguration.builderFor((String)"http://localhost");
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeDepthIsNotAllowed() {
        this.testBuilder().setMaximumDepth(-1).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeRuntimeIsNotAllowed() {
        this.testBuilder().setMaximumRunTime(-1L, TimeUnit.SECONDS).build();
    }

    @Test
    public void noArgsBuilderWorksFine() {
        this.testBuilder().build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void ifOutputIsFileNotFolderReject() throws Exception {
        File file = File.createTempFile(this.getClass().getSimpleName(), "tmp");
        file.deleteOnExit();
        MatcherAssert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        this.testBuilder().setOutputDirectory(file).build();
    }

    @Test(expected=IllegalStateException.class)
    public void ifCannotCreateOutputFolderReject() {
        File file = new File("/this/should/not/be/writable");
        this.testBuilder().setOutputDirectory(file).build();
    }

    @Test
    public void whenSpecifyingBasicAuthTheUrlShouldBePreserved() {
        String url = "https://example.com/test/?a=b#anchor";
        CrawljaxConfiguration conf = CrawljaxConfiguration.builderFor((String)url).setBasicAuth("username", "password").build();
        MatcherAssert.assertThat((Object)conf.getBasicAuthUrl().toString(), (Matcher)Is.is((Object)"https://username:password@example.com/test/?a=b#anchor"));
    }

    @Test
    public void shouldReturnDefaultCrawlScopeIfNoneSet() throws Exception {
        CrawlScope crawlScope = this.testBuilder().build().getCrawlScope();
        MatcherAssert.assertThat((Object)crawlScope, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(DefaultCrawlScope.class)));
        MatcherAssert.assertThat((Object)((DefaultCrawlScope)crawlScope).getUrl().toString(), (Matcher)Is.is((Object)"http://localhost"));
    }

    @Test
    public void shouldReturnCrawlScopeSet() throws Exception {
        CrawlScope crawlScope = url -> true;
        CrawljaxConfiguration conf = this.testBuilder().setCrawlScope(crawlScope).build();
        MatcherAssert.assertThat((Object)conf.getCrawlScope(), (Matcher)Is.is((Object)crawlScope));
    }
}

