/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.core.configuration.DefaultCrawlScope;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class DefaultCrawlScopeTest {
    private static final URI SEED = URI.create("http://localhost/");

    @Test(expected=NullPointerException.class)
    public void nullSeedDomainIsNotAllowed() throws Exception {
        new DefaultCrawlScope((URI)null);
    }

    @Test
    public void defaultCrawlScopeShouldIncludeSeedDomain() throws Exception {
        DefaultCrawlScope defaultCrawlScope = new DefaultCrawlScope(SEED);
        MatcherAssert.assertThat((Object)defaultCrawlScope.isInScope("http://localhost/in/scope"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void defaultCrawlScopeShouldNotIncludeNonSeedDomain() throws Exception {
        DefaultCrawlScope defaultCrawlScope = new DefaultCrawlScope(SEED);
        MatcherAssert.assertThat((Object)defaultCrawlScope.isInScope("http://example.com/not/in/scope"), (Matcher)Is.is((Object)false));
    }
}

