/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.configuration;

import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import org.hamcrest.MatcherAssert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class UnderXPathTest {
    @ClassRule
    public static final RunWithWebServer SERVER = new RunWithWebServer("/site");

    @Test
    public void testDontClickUnderXPath() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("underxpath.html");
        builder.crawlRules().click("a");
        builder.crawlRules().dontClick("a").underXPath("//A[@class=\"noClickClass\"]");
        CrawlRules.CrawlRulesBuilder rules = builder.crawlRules();
        rules.dontClick("a").withAttribute("id", "noClickId");
        rules.dontClickChildrenOf("div").withClass("noChildrenOfClass");
        rules.dontClickChildrenOf("div").withId("noChildrenOfId");
        CrawlSession session = new CrawljaxRunner(builder.build()).call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(2));
    }
}

