/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.largetests;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.BrowserOptions;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.largetests.LargeTestBase;
import com.crawljax.test.BrowserTest;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class LargeClickableTest
extends LargeTestBase {
    static void addCrawlElements(CrawljaxConfiguration.CrawljaxConfigurationBuilder builder) {
        CrawlRules.CrawlRulesBuilder rules = builder.crawlRules();
        rules.clickElementsWithClickEventHandler();
        rules.dontClick("button").withText("DONT_CLICK_ME_BECAUSE_OF_CONDITION");
        rules.dontClick("div").withText("DONT_CLICK_ME_BECAUSE_I_AM_A_NORMALE_DIV");
        rules.dontClick("a").withText("DONT_CLICK_ME");
        rules.dontClick("div").withText("DONT_CLICK_ME");
        rules.dontClick("a").withAttribute("class", "DONT_CLICK_ME");
        rules.dontClick("a").underXPath("//DIV[@id='DONT_CLICK_IN_HERE']");
    }

    @Override
    BrowserConfiguration getBrowserConfiguration() {
        BrowserOptions browserOptions = new BrowserOptions();
        browserOptions.setUSE_CDP(true);
        return new BrowserConfiguration(EmbeddedBrowser.BrowserType.CHROME_HEADLESS, 1, browserOptions);
    }

    @Override
    long getTimeOutAfterReloadUrl() {
        return 100L;
    }

    @Override
    long getTimeOutAfterEvent() {
        return 100L;
    }

    @Override
    protected CrawljaxConfiguration getCrawljaxConfiguration() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((URI)WEB_SERVER.getSiteUrl());
        builder.crawlRules().waitAfterEvent(this.getTimeOutAfterEvent(), TimeUnit.MILLISECONDS);
        builder.crawlRules().waitAfterReloadUrl(this.getTimeOutAfterReloadUrl(), TimeUnit.MILLISECONDS);
        builder.setMaximumDepth(3);
        builder.crawlRules().clickOnce(true);
        builder.setBrowserConfig(this.getBrowserConfiguration());
        LargeClickableTest.addCrawlElements(builder);
        builder.crawlRules().setInputSpec(LargeClickableTest.getInputSpecification());
        builder.crawlRules().setFormFillMode(CrawlRules.FormFillMode.RANDOM);
        LargeClickableTest.addCrawlConditions(builder);
        LargeClickableTest.addOracleComparators(builder);
        LargeClickableTest.addInvariants(builder);
        LargeClickableTest.addWaitConditions(builder);
        LargeClickableTest.addPlugins(builder);
        return builder.build();
    }
}

