/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.largetests;

import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.condition.Condition;
import com.crawljax.condition.NotRegexCondition;
import com.crawljax.condition.NotXPathCondition;
import com.crawljax.condition.RegexCondition;
import com.crawljax.condition.XPathCondition;
import com.crawljax.condition.browserwaiter.ExpectedCondition;
import com.crawljax.condition.browserwaiter.ExpectedVisibleCondition;
import com.crawljax.condition.browserwaiter.WaitCondition;
import com.crawljax.condition.invariant.Invariant;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.configuration.Form;
import com.crawljax.core.configuration.InputSpecification;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.PostCrawlStateGraphChecker;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.forms.FormInput;
import com.crawljax.forms.FormInputValueHelper;
import com.crawljax.oraclecomparator.Comparator;
import com.crawljax.oraclecomparator.OracleComparator;
import com.crawljax.oraclecomparator.comparators.DateComparator;
import com.crawljax.oraclecomparator.comparators.StyleComparator;
import com.crawljax.test.RunWithWebServer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LargeTestBase {
    @ClassRule
    public static final RunWithWebServer WEB_SERVER = new RunWithWebServer("/site");
    static final String CLICK_TEXT = "CLICK_ME";
    static final String DONT_CLICK_TEXT = "DONT_CLICK_ME";
    static final String ATTRIBUTE = "class";
    static final String CLICK_UNDER_XPATH_ID = "CLICK_IN_HERE";
    static final String DONT_CLICK_UNDER_XPATH_ID = "DONT_CLICK_IN_HERE";
    private static final Logger LOG = LoggerFactory.getLogger(LargeTestBase.class);
    private static final AtomicBoolean HAS_RUN = new AtomicBoolean(false);
    private static final AtomicBoolean HAS_FINISHED = new AtomicBoolean(false);
    private static final int CLICKED_CLICK_ME_ELEMENTS = 6;
    private static final String ILLEGAL_STATE = "FORBIDDEN_PAGE";
    private static final int VIOLATED_INVARIANTS = 1;
    private static final String VIOLATED_INVARIANT_DESCRIPTION = "expectedInvariantViolation";
    private static final String INVARIANT_TEXT = "TEST_INVARIANTS";
    private static final String TITLE_RESULT_RANDOM_INPUT = "RESULT_RANDOM_INPUT";
    private static final String REGEX_RESULT_RANDOM_INPUT = "[a-zA-Z]{8};[a-zA-Z]{8};(true|false);(true|false);OPTION[1234];[a-zA-Z]{8}";
    private static final String TITLE_MANUAL_INPUT_RESULT = "RESULT_MANUAL_INPUT";
    private static final String MANUAL_INPUT_TEXT = "foo";
    private static final String MANUAL_INPUT_TEXT2 = "crawljax";
    private static final boolean MANUAL_INPUT_CHECKBOX = true;
    private static final boolean MANUAL_INPUT_RADIO = false;
    private static final String MANUAL_INPUT_SELECT = "OPTION4";
    private static final String MANUAL_INPUT_TEXTAREA = "bar";
    private static final String MANUAL_INPUT_RESULT = "foo;crawljax;true;false;OPTION4;bar";
    private static final String[] MULTIPLE_INPUT_TEXT = new String[]{"first", "second", ""};
    private static final String[] MULTIPLE_INPUT_TEXT2 = new String[]{"foo", "bar"};
    private static final boolean[] MULTIPLE_INPUT_CHECKBOX = new boolean[]{true, false};
    private static final boolean[] MULTIPLE_INPUT_RADIO = new boolean[]{false, true};
    private static final String[] MULTIPLE_INPUT_SELECT = new String[]{"OPTION1", "OPTION2"};
    private static final String[] MULTIPLE_INPUT_TEXTAREA = new String[]{"same"};
    private static final String TITLE_MULTIPLE_INPUT_RESULT = "RESULT_MULTIPLE_INPUT";
    private static final String[] MULTIPLE_INPUT_RESULTS = new String[]{"first;foo;true;false;OPTION1;same", "second;bar;false;true;OPTION2;same", ";foo;true;false;OPTION1;same"};
    private static CrawlSession session;
    private static List<Invariant> violatedInvariants;
    private static boolean violatedInvariantStateIsCorrect;
    @Rule
    public final Timeout timeout = new Timeout(15L, TimeUnit.MINUTES);

    static InputSpecification getInputSpecification() {
        InputSpecification input = new InputSpecification();
        input.inputField(FormInput.InputType.TEXT, new Identification(Identification.How.id, "textManual")).inputValues(new String[]{MANUAL_INPUT_TEXT});
        input.inputField(FormInput.InputType.TEXT, new Identification(Identification.How.id, "text2Manual")).inputValues(new String[]{MANUAL_INPUT_TEXT2});
        input.inputField(FormInput.InputType.CHECKBOX, new Identification(Identification.How.id, "checkboxManual")).inputValues(new boolean[]{true});
        input.inputField(FormInput.InputType.RADIO, new Identification(Identification.How.id, "radioManual")).inputValues(new boolean[]{false});
        input.inputField(FormInput.InputType.SELECT, new Identification(Identification.How.id, "selectManual")).inputValues(new String[]{MANUAL_INPUT_SELECT});
        input.inputField(FormInput.InputType.TEXTAREA, new Identification(Identification.How.id, "textareaManual")).inputValues(new String[]{MANUAL_INPUT_TEXTAREA});
        Form form = new Form();
        form.inputField(FormInput.InputType.TEXT, new Identification(Identification.How.id, "textMultiple")).inputValues(MULTIPLE_INPUT_TEXT);
        form.inputField(FormInput.InputType.TEXT, new Identification(Identification.How.id, "text2Multiple")).inputValues(MULTIPLE_INPUT_TEXT2);
        form.inputField(FormInput.InputType.CHECKBOX, new Identification(Identification.How.id, "checkboxMultiple")).inputValues(MULTIPLE_INPUT_CHECKBOX);
        form.inputField(FormInput.InputType.RADIO, new Identification(Identification.How.id, "radioMultiple")).inputValues(MULTIPLE_INPUT_RADIO);
        form.inputField(FormInput.InputType.SELECT, new Identification(Identification.How.id, "selectMultiple")).inputValues(MULTIPLE_INPUT_SELECT);
        form.inputField(FormInput.InputType.TEXTAREA, new Identification(Identification.How.id, "textareaMultiple")).inputValues(MULTIPLE_INPUT_TEXTAREA);
        input.setValuesInForm(form).beforeClickElement("a").withText("Submit Multiple");
        return input;
    }

    static void addWaitConditions(CrawljaxConfiguration.CrawljaxConfigurationBuilder crawler) {
        crawler.crawlRules().addWaitCondition(new WaitCondition[]{new WaitCondition("testWaitCondition.html", 2000, new ExpectedCondition[]{new ExpectedVisibleCondition(new Identification(Identification.How.id, "SLOW_WIDGET"))})});
    }

    static void addInvariants(CrawljaxConfiguration.CrawljaxConfigurationBuilder builder) {
        NotXPathCondition neverDivWithInvariantViolationId = new NotXPathCondition("//DIV[@id='INVARIANT_VIOLATION']");
        builder.crawlRules().addInvariant(VIOLATED_INVARIANT_DESCRIPTION, (Condition)neverDivWithInvariantViolationId);
        RegexCondition onInvariantsPagePreCondition = new RegexCondition(INVARIANT_TEXT);
        XPathCondition expectElement = new XPathCondition("//DIV[@id='SHOULD_ALWAYS_BE_ON_THIS_PAGE']");
        builder.crawlRules().addInvariant(new Invariant[]{new Invariant("testInvariantWithPrecondiions", (Condition)expectElement, new Condition[]{onInvariantsPagePreCondition})});
    }

    static void addCrawlElements(CrawljaxConfiguration.CrawljaxConfigurationBuilder builder) {
        CrawlRules.CrawlRulesBuilder rules = builder.crawlRules();
        rules.click("a");
        rules.click("div").withText(CLICK_TEXT);
        rules.click("div").underXPath("//SPAN[@id='CLICK_IN_HERE']");
        rules.click("button").when(new Condition[]{new NotRegexCondition("DONT_CLICK_BUTTONS_ON_THIS_PAGE")});
        rules.click("div").withAttribute(ATTRIBUTE, "condition").when(new Condition[]{new RegexCondition("REGEX_CONDITION_TRUE")});
        rules.dontClick("a").withText(DONT_CLICK_TEXT);
        rules.dontClick("a").withAttribute(ATTRIBUTE, DONT_CLICK_TEXT);
        rules.dontClick("a").underXPath("//DIV[@id='DONT_CLICK_IN_HERE']");
    }

    static void addOracleComparators(CrawljaxConfiguration.CrawljaxConfigurationBuilder builder) {
        builder.crawlRules().addOracleComparator(new OracleComparator[]{new OracleComparator("style", (Comparator)new StyleComparator())});
        builder.crawlRules().addOracleComparator(new OracleComparator[]{new OracleComparator("date", (Comparator)new DateComparator())});
    }

    static void addCrawlConditions(CrawljaxConfiguration.CrawljaxConfigurationBuilder builder) {
        builder.crawlRules().addCrawlCondition("DONT_CRAWL_ME", (Condition)new NotRegexCondition("DONT_CRAWL_ME"));
    }

    protected static void addPlugins(CrawljaxConfiguration.CrawljaxConfigurationBuilder crawljaxConfiguration) {
        crawljaxConfiguration.addPlugin(new Plugin[]{new PostCrawlStateGraphChecker()});
        crawljaxConfiguration.addPlugin(new Plugin[]{(invariant, context) -> {
            violatedInvariants.add(invariant);
            if (context.getBrowser().getStrippedDom().contains(INVARIANT_TEXT)) {
                violatedInvariantStateIsCorrect = true;
                LOG.warn("Invariant violated: " + invariant.getDescription());
            }
        }});
    }

    @Before
    public void setup() throws Exception {
        FormInputValueHelper.reset();
        if (!HAS_RUN.get()) {
            HAS_RUN.set(true);
            CrawljaxRunner crawljax = null;
            crawljax = new CrawljaxRunner(this.getCrawljaxConfiguration());
            session = crawljax.call();
            HAS_FINISHED.set(true);
        } else {
            while (!HAS_FINISHED.get()) {
                LOG.debug("Waiting for crawl to finish...");
                Thread.sleep(500L);
            }
        }
    }

    protected CrawljaxConfiguration getCrawljaxConfiguration() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((URI)WEB_SERVER.getSiteUrl());
        builder.crawlRules().waitAfterEvent(this.getTimeOutAfterEvent(), TimeUnit.MILLISECONDS);
        builder.crawlRules().waitAfterReloadUrl(this.getTimeOutAfterReloadUrl(), TimeUnit.MILLISECONDS);
        builder.setMaximumDepth(3);
        builder.crawlRules().clickOnce(true);
        builder.setBrowserConfig(this.getBrowserConfiguration());
        LargeTestBase.addCrawlElements(builder);
        builder.crawlRules().setInputSpec(LargeTestBase.getInputSpecification());
        builder.crawlRules().setFormFillMode(CrawlRules.FormFillMode.RANDOM);
        LargeTestBase.addCrawlConditions(builder);
        LargeTestBase.addOracleComparators(builder);
        LargeTestBase.addInvariants(builder);
        LargeTestBase.addWaitConditions(builder);
        LargeTestBase.addPlugins(builder);
        return builder.build();
    }

    private StateFlowGraph getStateFlowGraph() {
        return session.getStateFlowGraph();
    }

    @Test
    public void testRandomFormInput() {
        for (StateVertex state : this.getStateFlowGraph().getAllStates()) {
            if (!state.getDom().contains(TITLE_RESULT_RANDOM_INPUT)) continue;
            Pattern p = Pattern.compile(REGEX_RESULT_RANDOM_INPUT);
            Matcher m = p.matcher(state.getDom());
            Assert.assertTrue((String)"Found correct random result", (boolean)m.find());
            return;
        }
        Assert.fail((String)"Result random input found");
    }

    @Test
    public void testManualFormInput() {
        String[] parts = MANUAL_INPUT_RESULT.split(";");
        for (StateVertex state : this.getStateFlowGraph().getAllStates()) {
            if (!state.getDom().contains(TITLE_MANUAL_INPUT_RESULT)) continue;
            for (String part : parts) {
                Assert.assertTrue((String)("DOM must contain: " + part), (boolean)state.getDom().contains(part));
            }
            return;
        }
        Assert.fail((String)"Result manual input found");
    }

    @Test
    public void testMultipleFormInput() {
        HashSet<String> resultsFound = new HashSet<String>();
        for (StateVertex state : this.getStateFlowGraph().getAllStates()) {
            if (!state.getDom().contains(TITLE_MULTIPLE_INPUT_RESULT)) continue;
            for (String result : MULTIPLE_INPUT_RESULTS) {
                String[] parts;
                for (String part : parts = result.split(";")) {
                    if (!state.getDom().contains(part)) continue;
                    resultsFound.add(result);
                }
            }
        }
        MatcherAssert.assertThat(resultsFound, (org.hamcrest.Matcher)Matchers.containsInAnyOrder((Object[])MULTIPLE_INPUT_RESULTS));
    }

    @Test
    public void testCrawledElements() {
        int clickMeFound = 0;
        for (Eventable eventable : this.getStateFlowGraph().getAllEdges()) {
            if (eventable.getEventType() == Eventable.EventType.reload) continue;
            Assert.assertTrue((String)("No illegal element is clicked: " + eventable), (!eventable.getElement().getText().startsWith(DONT_CLICK_TEXT) ? 1 : 0) != 0);
            if (!eventable.getElement().getText().startsWith(CLICK_TEXT)) continue;
            ++clickMeFound;
        }
        Assert.assertTrue((String)"6 CLICK_TEXT elements are clicked ", (clickMeFound == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testForIllegalStates() {
        MatcherAssert.assertThat((Object)this.getStateFlowGraph().getAllStates(), (org.hamcrest.Matcher)Matchers.everyItem((org.hamcrest.Matcher)IsNot.not(StateFlowGraphMatchers.stateWithDomSubstring(ILLEGAL_STATE))));
    }

    @Test
    public void testOracleComparators() {
        int countHomeStates = 0;
        for (StateVertex state : this.getStateFlowGraph().getAllStates()) {
            if (!state.getDom().contains("HOMEPAGE")) continue;
            ++countHomeStates;
        }
        Assert.assertTrue((String)("Only one home page. Found: " + countHomeStates), (countHomeStates == 1 ? 1 : 0) != 0);
    }

    @Test
    @Ignore(value="This test is non-deterministic and will fail without cause.")
    public void testInvariants() {
        Assert.assertTrue((String)(violatedInvariants.size() + " Invariants violated"), (violatedInvariants.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"expectedInvariantViolation failed", (boolean)violatedInvariants.get(0).getDescription().equals(VIOLATED_INVARIANT_DESCRIPTION));
    }

    @Test
    @Ignore(value="This test is non-deterministic and will fail without cause.")
    public void testCorrectStateOnViolatedInvariants() {
        Assert.assertTrue((String)"OnViolatedInvariantPlugin session object has the correct currentState", (boolean)violatedInvariantStateIsCorrect);
    }

    @Test
    public void testWaitCondition() {
        boolean foundSlowWidget = false;
        for (StateVertex state : this.getStateFlowGraph().getAllStates()) {
            if (!state.getDom().contains("TEST_WAITCONDITION") || !state.getDom().contains("LOADED_SLOW_WIDGET")) continue;
            foundSlowWidget = true;
        }
        Assert.assertTrue((String)"SLOW_WIDGET is found", (boolean)foundSlowWidget);
        boolean foundLinkInSlowWidget = false;
        for (Eventable eventable : this.getStateFlowGraph().getAllEdges()) {
            if (eventable.getEventType() == Eventable.EventType.reload || !eventable.getElement().getText().equals("SLOW_WIDGET_HOME")) continue;
            foundLinkInSlowWidget = true;
        }
        Assert.assertTrue((String)"Link in SLOW_WIDGET is found", (boolean)foundLinkInSlowWidget);
    }

    abstract BrowserConfiguration getBrowserConfiguration();

    abstract long getTimeOutAfterReloadUrl();

    abstract long getTimeOutAfterEvent();

    static {
        violatedInvariants = new ArrayList<Invariant>();
        violatedInvariantStateIsCorrect = false;
    }
}

