/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.plugin;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.html.dom.HTMLAnchorElementImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class OnFireEventFailedPluginTest {
    @ClassRule
    public static final RunWithWebServer SERVER = new RunWithWebServer("site");
    private final AtomicInteger hits = new AtomicInteger();
    private CrawljaxRunner controller;

    @Before
    public void setup() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("crawler/index.html");
        builder.addPlugin(new Plugin[]{(session, candidateElements, state) -> {
            for (CandidateElement candidate : candidateElements) {
                HTMLAnchorElementImpl impl = (HTMLAnchorElementImpl)candidate.getElement();
                impl.setName("fail");
                impl.setId("eventually");
                impl.setHref("will");
                impl.setTextContent("This");
                candidate.getIdentification().setValue("/HTML[1]/BODY[1]/FAILED[1]/A[1]");
            }
        }});
        builder.addPlugin(new Plugin[]{(context, eventable, pathToFailure) -> this.hits.incrementAndGet()});
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        this.controller = new CrawljaxRunner(builder.build());
    }

    @Test
    public void testFireEventFailedHasBeenExecuted() throws CrawljaxException {
        this.controller.call();
        MatcherAssert.assertThat((String)"The FireEventFailed Plugin has been executed the correct amount of times", (Object)this.hits.get(), (Matcher)Is.is((Object)2));
    }
}

