/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.plugin;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.invariant.Invariant;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.OnBrowserCreatedPlugin;
import com.crawljax.core.plugin.OnFireEventFailedPlugin;
import com.crawljax.core.plugin.OnInvariantViolationPlugin;
import com.crawljax.core.plugin.OnNewStatePlugin;
import com.crawljax.core.plugin.OnRevisitStatePlugin;
import com.crawljax.core.plugin.OnUrlLoadPlugin;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.plugin.PostCrawlingPlugin;
import com.crawljax.core.plugin.PreStateCrawlingPlugin;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateVertex;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PluginsTest {
    private Plugins plugins;
    @Mock
    private OnBrowserCreatedPlugin browserCreatedPlugin;
    @Mock
    private OnFireEventFailedPlugin fireEventFailedPlugin;
    @Mock
    private OnInvariantViolationPlugin invariantViolationPlugin;
    @Mock
    private OnNewStatePlugin newStatePlugin;
    @Mock
    private OnRevisitStatePlugin onRevisitStatePlugin;
    @Mock
    private OnUrlLoadPlugin urlLoadPlugin;
    @Mock
    private PostCrawlingPlugin postCrawlingPlugin;
    @Mock
    private PreStateCrawlingPlugin preStatePlugin;
    @Mock
    private CrawlerContext context;
    @Mock
    private CrawlSession session;
    @Mock
    private StateVertex vertex;
    private MetricRegistry registry;

    @Before
    public void setup() {
        this.registry = new MetricRegistry();
        CrawljaxConfiguration config = CrawljaxConfiguration.builderFor((String)"http://localhost").addPlugin(new Plugin[]{this.browserCreatedPlugin, this.fireEventFailedPlugin, this.invariantViolationPlugin, this.newStatePlugin, this.onRevisitStatePlugin, this.urlLoadPlugin, this.postCrawlingPlugin, this.preStatePlugin}).setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType())).build();
        this.plugins = new Plugins(config, this.registry);
    }

    @Test
    public void testAllCountersRegistered() {
        MatcherAssert.assertThat((Object)this.registry.getCounters().size(), (Matcher)Is.is((Object)Plugins.KNOWN_PLUGINS.size()));
    }

    @Test
    public void postCrawlPluginIsCalled() {
        this.plugins.runPostCrawlingPlugins(this.session, ExitNotifier.ExitStatus.EXHAUSTED);
        ((PostCrawlingPlugin)Mockito.verify((Object)this.postCrawlingPlugin)).postCrawling(this.session, ExitNotifier.ExitStatus.EXHAUSTED);
        MatcherAssert.assertThat((Object)this.counterFor(PostCrawlingPlugin.class), (Matcher)Is.is((Object)1));
    }

    private int counterFor(Class<? extends Plugin> plugin) {
        for (Map.Entry counter : this.registry.getCounters().entrySet()) {
            if (!((String)counter.getKey()).contains(plugin.getSimpleName()) || !((String)counter.getKey()).endsWith("invocations")) continue;
            return (int)((Counter)counter.getValue()).getCount();
        }
        Assert.fail((String)("No counter found for " + plugin.getClass().getSimpleName()));
        return -1;
    }

    @Test
    public void urlLoadIsCalled() {
        this.plugins.runOnUrlLoadPlugins(this.context);
        ((OnUrlLoadPlugin)Mockito.verify((Object)this.urlLoadPlugin)).onUrlLoad(this.context);
        MatcherAssert.assertThat((Object)this.counterFor(OnUrlLoadPlugin.class), (Matcher)Is.is((Object)1));
    }

    @Test
    public void revisitStatePluginIsCalled() {
        StateVertex currentState = (StateVertex)Mockito.mock(StateVertex.class);
        this.plugins.runOnRevisitStatePlugins(this.context, currentState);
        ((OnRevisitStatePlugin)Mockito.verify((Object)this.onRevisitStatePlugin)).onRevisitState(this.context, currentState);
        MatcherAssert.assertThat((Object)this.counterFor(OnRevisitStatePlugin.class), (Matcher)Is.is((Object)1));
    }

    @Test
    public void newStatePluginIsCalled() {
        this.plugins.runOnNewStatePlugins(this.context, this.vertex);
        ((OnNewStatePlugin)Mockito.verify((Object)this.newStatePlugin)).onNewState(this.context, this.vertex);
        MatcherAssert.assertThat((Object)this.counterFor(OnNewStatePlugin.class), (Matcher)Is.is((Object)1));
    }

    @Test
    public void invariantViolatedIsCalled() {
        Invariant invariant = (Invariant)Mockito.mock(Invariant.class);
        this.plugins.runOnInvariantViolationPlugins(invariant, this.context);
        ((OnInvariantViolationPlugin)Mockito.verify((Object)this.invariantViolationPlugin)).onInvariantViolation(invariant, this.context);
        MatcherAssert.assertThat((Object)this.counterFor(OnInvariantViolationPlugin.class), (Matcher)Is.is((Object)1));
    }

    @Test
    public void browserCreatedIsCalled() {
        EmbeddedBrowser newBrowser = (EmbeddedBrowser)Mockito.mock(EmbeddedBrowser.class);
        this.plugins.runOnBrowserCreatedPlugins(newBrowser);
        ((OnBrowserCreatedPlugin)Mockito.verify((Object)this.browserCreatedPlugin)).onBrowserCreated(newBrowser);
        MatcherAssert.assertThat((Object)this.counterFor(OnBrowserCreatedPlugin.class), (Matcher)Is.is((Object)1));
    }

    @Test
    public void verifyPreCrawlPluginIsCalled() {
        ImmutableList candidateElements = ImmutableList.of();
        this.plugins.runPreStateCrawlingPlugins(this.context, candidateElements, this.vertex);
        ((PreStateCrawlingPlugin)Mockito.verify((Object)this.preStatePlugin)).preStateCrawling(this.context, candidateElements, this.vertex);
        MatcherAssert.assertThat((Object)this.counterFor(PreStateCrawlingPlugin.class), (Matcher)Is.is((Object)1));
    }

    @Test
    public void fireEventFailedIsCalled() {
        ImmutableList path = ImmutableList.of();
        Eventable eventable = (Eventable)Mockito.mock(Eventable.class);
        this.plugins.runOnFireEventFailedPlugins(this.context, eventable, (List)path);
        ((OnFireEventFailedPlugin)Mockito.verify((Object)this.fireEventFailedPlugin)).onFireEventFailed(this.context, eventable, (List)path);
        MatcherAssert.assertThat((Object)this.counterFor(OnFireEventFailedPlugin.class), (Matcher)Is.is((Object)1));
    }
}

