/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.plugin;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.condition.Condition;
import com.crawljax.condition.NotRegexCondition;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.OnBrowserCreatedPlugin;
import com.crawljax.core.plugin.OnFireEventFailedPlugin;
import com.crawljax.core.plugin.OnInvariantViolationPlugin;
import com.crawljax.core.plugin.OnNewStatePlugin;
import com.crawljax.core.plugin.OnRevisitStatePlugin;
import com.crawljax.core.plugin.OnUrlLoadPlugin;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.plugin.PostCrawlingPlugin;
import com.crawljax.core.plugin.PreCrawlingPlugin;
import com.crawljax.core.plugin.PreStateCrawlingPlugin;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.html.dom.HTMLAnchorElementImpl;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.object.IsCompatibleType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ErrorCollector;

@Category(value={BrowserTest.class})
public class PluginsWithCrawlerTest {
    @ClassRule
    public static final RunWithWebServer SERVER = new RunWithWebServer("/site");
    @ClassRule
    public static final ErrorCollector ERRORS = new ErrorCollector();
    private static String listAsString;
    private static List<Class<? extends Plugin>> plugins;
    private static CrawlSession session;

    @BeforeClass
    public static void setup() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("crawler/");
        builder.crawlRules().clickDefaultElements();
        builder.crawlRules().addInvariant("Never contain Final state S8", (Condition)new NotRegexCondition("Final state S2"));
        builder.addPlugin(new Plugin[]{config -> plugins.add(PreCrawlingPlugin.class)});
        builder.addPlugin(new Plugin[]{(context, state) -> {
            plugins.add(OnNewStatePlugin.class);
            if (!state.getName().equals("index")) {
                Assert.assertTrue((String)"currentState and indexState are never the same", (!state.equals(context.getSession().getInitialState()) ? 1 : 0) != 0);
            }
        }});
        builder.addPlugin(new Plugin[]{newBrowser -> {
            plugins.add(OnBrowserCreatedPlugin.class);
            Assert.assertNotNull((Object)newBrowser);
        }});
        builder.addPlugin(new Plugin[]{(invariant, context) -> {
            plugins.add(OnInvariantViolationPlugin.class);
            Assert.assertNotNull((Object)invariant);
        }});
        builder.addPlugin(new Plugin[]{browser -> {
            plugins.add(OnUrlLoadPlugin.class);
            Assert.assertNotNull((Object)browser);
        }});
        builder.addPlugin(new Plugin[]{(session, status) -> plugins.add(PostCrawlingPlugin.class)});
        builder.addPlugin(new Plugin[]{(session, candidateElements, state) -> {
            plugins.add(PreStateCrawlingPlugin.class);
            try {
                Assert.assertNotNull((Object)candidateElements);
            }
            catch (AssertionError e) {
                ERRORS.addError((Throwable)((Object)e));
            }
            if (state.getName().equals("state8")) {
                CandidateElement candidate = (CandidateElement)candidateElements.get(0);
                HTMLAnchorElementImpl impl = (HTMLAnchorElementImpl)candidate.getElement();
                impl.setName("fail");
                impl.setId("eventually");
                impl.setHref("will");
                impl.setTextContent("This");
                candidate.getIdentification().setValue("/HTML[1]/BODY[1]/FAILED[1]/A[1]");
            }
        }});
        builder.addPlugin(new Plugin[]{(session, currentState) -> {
            plugins.add(OnRevisitStatePlugin.class);
            Assert.assertNotNull((Object)currentState);
        }});
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        CrawljaxConfiguration config2 = builder.build();
        try {
            System.out.println(plugins.get(1).getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrawljaxRunner controller = new CrawljaxRunner(config2);
        PluginsWithCrawlerTest.session = controller.call();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < plugins.size(); ++i) {
            Class<? extends Plugin> plugin = plugins.get(i);
            sb.append('\n').append(i).append(' ').append(plugin.getSimpleName());
        }
        listAsString = sb.toString();
    }

    @Test
    public void whenCrawlStartsInitialPluginsAreRun() {
        MatcherAssert.assertThat(plugins.get(0), (Matcher)IsCompatibleType.typeCompatibleWith(PreCrawlingPlugin.class));
        MatcherAssert.assertThat(plugins.get(1), (Matcher)IsCompatibleType.typeCompatibleWith(OnBrowserCreatedPlugin.class));
        MatcherAssert.assertThat(plugins.get(2), (Matcher)IsCompatibleType.typeCompatibleWith(OnUrlLoadPlugin.class));
    }

    @Test
    public void whenCrawlFinishesTheLastPluginIsTheOverviewPlugin() {
        MatcherAssert.assertThat(plugins.get(plugins.size() - 1), (Matcher)IsCompatibleType.typeCompatibleWith(PostCrawlingPlugin.class));
    }

    @Test
    public void verifyOnUrlLoadFollowers() {
        this.afterFirstPluginsIsFollowedBy(OnUrlLoadPlugin.class, (Iterable<Class<? extends Plugin>>)ImmutableSet.of(OnInvariantViolationPlugin.class, OnNewStatePlugin.class, OnRevisitStatePlugin.class, PostCrawlingPlugin.class));
    }

    private void afterFirstPluginsIsFollowedBy(Class<OnUrlLoadPlugin> suspect, Iterable<Class<? extends Plugin>> followedBy) {
        List<Integer> indexes = this.indexesOf(suspect);
        if (indexes.size() > 0) {
            indexes.remove(0);
        }
        for (int index : indexes) {
            Class<? extends Plugin> follower = plugins.get(index + 1);
            MatcherAssert.assertThat((String)(suspect + " @index=" + index + " was followed by " + follower + listAsString), followedBy, (Matcher)IsCollectionContaining.hasItem(follower));
        }
    }

    public void pluginsIsFollowedBy(Class<? extends Plugin> suspect, Iterable<Class<? extends Plugin>> followedBy) {
        for (int index : this.indexesOf(suspect)) {
            Class<? extends Plugin> follower = plugins.get(index + 1);
            MatcherAssert.assertThat((String)(suspect + " @index=" + index + " was followed by " + follower + listAsString), followedBy, (Matcher)IsCollectionContaining.hasItem(follower));
        }
    }

    private List<Integer> indexesOf(Class<? extends Plugin> clazz) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < plugins.size(); ++i) {
            if (!plugins.get(i).isAssignableFrom(clazz)) continue;
            indexes.add(i);
        }
        return indexes;
    }

    @Test
    public void verifyOnNewStateFollowers() {
        this.pluginsIsFollowedBy(OnNewStatePlugin.class, (Iterable<Class<? extends Plugin>>)ImmutableSet.of(PreStateCrawlingPlugin.class, OnUrlLoadPlugin.class, PostCrawlingPlugin.class));
    }

    @Test
    public void verifyPreStateCrawlingFollowers() {
        this.pluginsIsFollowedBy(PreStateCrawlingPlugin.class, (Iterable<Class<? extends Plugin>>)ImmutableSet.of(OnFireEventFailedPlugin.class, OnInvariantViolationPlugin.class, OnNewStatePlugin.class, OnUrlLoadPlugin.class, PostCrawlingPlugin.class));
    }

    @Test
    public void onRevisitStatesFollowers() {
        this.pluginsIsFollowedBy(OnRevisitStatePlugin.class, (Iterable<Class<? extends Plugin>>)ImmutableSet.of(OnFireEventFailedPlugin.class, OnInvariantViolationPlugin.class, OnNewStatePlugin.class));
    }

    @Test
    public void startAndEndPluginsAreOnlyRunOnce() {
        MatcherAssert.assertThat((Object)this.occurrencesOf(PreCrawlingPlugin.class), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.occurrencesOf(PostCrawlingPlugin.class), (Matcher)Is.is((Object)1));
    }

    @Test
    public void newStatePluginCallsAreEqualToNumberOfStates() {
        int numberOfStates = session.getStateFlowGraph().getAllStates().size();
        MatcherAssert.assertThat((Object)this.occurrencesOf(OnNewStatePlugin.class), (Matcher)Is.is((Object)numberOfStates));
    }

    private int occurrencesOf(Class<? extends Plugin> clazz) {
        int count = 0;
        for (Class<? extends Plugin> plugin : plugins) {
            if (!plugin.isAssignableFrom(clazz)) continue;
            ++count;
        }
        return count;
    }

    static {
        plugins = new BlockingArrayQueue();
    }
}

