/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.CrawljaxException;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.state.DefaultStateVertexFactory;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexFactory;
import com.crawljax.core.state.StateVertexImpl;
import com.crawljax.util.DomUtils;
import java.io.IOException;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventableTest {
    @Test
    public void testHashCode() {
        String xpath = "/body/div[3]";
        Identification id = new Identification(Identification.How.xpath, xpath);
        Eventable c = new Eventable(id, Eventable.EventType.click);
        Eventable temp = new Eventable(id, Eventable.EventType.click);
        Assert.assertEquals((long)temp.hashCode(), (long)c.hashCode());
        temp = new Eventable(new Identification(Identification.How.id, "34"), Eventable.EventType.click);
        Assert.assertNotSame((Object)temp.hashCode(), (Object)c.hashCode());
        temp = new Eventable(id, Eventable.EventType.hover);
        Assert.assertNotSame((Object)temp.hashCode(), (Object)c.hashCode());
    }

    @Test
    public void EventablesWithDifferentStatesAreNotEqual() throws IllegalArgumentException, SecurityException {
        Identification id = new Identification(Identification.How.xpath, "/DIV");
        Eventable event1 = new Eventable(id, Eventable.EventType.click);
        Eventable event2 = new Eventable(id, Eventable.EventType.click);
        MatcherAssert.assertThat((Object)event1, (Matcher)Is.is((Object)event2));
        StateVertex source = (StateVertex)Mockito.mock(StateVertex.class);
        StateVertex target1 = (StateVertex)Mockito.mock(StateVertex.class);
        StateVertex target2 = (StateVertex)Mockito.mock(StateVertex.class);
        event1.setSource(source);
        event2.setSource(source);
        MatcherAssert.assertThat((Object)event1, (Matcher)Is.is((Object)event2));
        event1.setTarget(target1);
        event2.setTarget(target2);
        MatcherAssert.assertThat((Object)event1, (Matcher)Is.is((Matcher)IsNot.not((Object)event2)));
    }

    @Test
    public void testToString() {
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/body/div[3]"), Eventable.EventType.click);
        Assert.assertNotNull((Object)c.toString());
    }

    @Test
    public void testEqualsObject() {
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/body/div[3]"), Eventable.EventType.click);
        Eventable b = new Eventable(new Identification(Identification.How.xpath, "/body/div[3]"), Eventable.EventType.click);
        Eventable d = new Eventable(new Identification(Identification.How.id, "23"), Eventable.EventType.click);
        Eventable e = new Eventable(new Identification(Identification.How.id, "23"), Eventable.EventType.hover);
        Assert.assertTrue((boolean)c.equals((Object)b));
        Assert.assertFalse((boolean)c.equals((Object)d));
        Assert.assertFalse((boolean)d.equals((Object)e));
    }

    @Test
    @Ignore(value="seems redundant")
    public void testGetInfo() {
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/body/div[3]"), Eventable.EventType.click);
        String info = " click xpath /body/div[3]";
        Assert.assertEquals((Object)info, (Object)c.toString());
    }

    @Test
    public void testClickableElement() throws IOException {
        String html = "<body><div id='firstdiv'></div><div><span id='thespan'><a id='thea'>test</a></span></div></body>";
        Document dom = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)dom);
        Element element = dom.getElementById("firstdiv");
        Eventable clickable = new Eventable((Node)element, Eventable.EventType.click);
        Assert.assertNotNull((Object)clickable);
        MatcherAssert.assertThat((Object)clickable.getIdentification().getHow(), (Matcher)Is.is((Object)Identification.How.xpath));
        MatcherAssert.assertThat((Object)clickable.getIdentification().getValue(), (Matcher)Is.is((Object)"/HTML[1]/BODY[1]/DIV[1]"));
        MatcherAssert.assertThat((Object)clickable.getElement().getAttributeOrNull("id"), (Matcher)Is.is((Object)"firstdiv"));
    }

    @Test
    public void testEdge() throws CrawljaxException {
        StateVertexImpl s1 = new StateVertexImpl(0, "stateSource", "dom1");
        StateVertexImpl s2 = new StateVertexImpl(0, "stateTarget", "dom2");
        InMemoryStateFlowGraph sfg = new InMemoryStateFlowGraph(new ExitNotifier(0), (StateVertexFactory)new DefaultStateVertexFactory());
        sfg.putIndex((StateVertex)s1);
        sfg.putIfAbsent((StateVertex)s2);
        Eventable e = new Eventable();
        sfg.addEdge((StateVertex)s1, (StateVertex)s2, e);
        Assert.assertEquals((Object)s1, (Object)e.getSourceStateVertex());
        Assert.assertEquals((Object)s2, (Object)e.getTargetStateVertex());
    }

    @Test
    public void testSets() {
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/body/div[3]"), Eventable.EventType.click);
        c.setId(1L);
        Eventable b = new Eventable(new Identification(Identification.How.xpath, "/body/div[3]"), Eventable.EventType.click);
        c.setId(2L);
        Eventable d = new Eventable(new Identification(Identification.How.id, "23"), Eventable.EventType.click);
        c.setId(3L);
        Eventable e = new Eventable(new Identification(Identification.How.id, "23"), Eventable.EventType.hover);
        c.setId(4L);
        Assert.assertTrue((boolean)c.equals((Object)b));
        Assert.assertEquals((long)c.hashCode(), (long)b.hashCode());
        HashSet<Eventable> setOne = new HashSet<Eventable>();
        setOne.add(b);
        setOne.add(c);
        setOne.add(d);
        setOne.add(e);
        Assert.assertEquals((long)3L, (long)setOne.size());
        HashSet<Eventable> setTwo = new HashSet<Eventable>();
        setTwo.add(b);
        setTwo.add(c);
        setTwo.add(d);
        Assert.assertEquals((long)2L, (long)setTwo.size());
        HashSet intersection = new HashSet(setOne);
        intersection.retainAll(setTwo);
        Assert.assertEquals((long)2L, (long)intersection.size());
        HashSet difference = new HashSet(setOne);
        difference.removeAll(setTwo);
        Assert.assertEquals((long)1L, (long)difference.size());
    }
}

