/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.CrawlSession;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.plugin.PostCrawlingPlugin;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.number.OrderingComparison;

public class PostCrawlStateGraphChecker
implements PostCrawlingPlugin {
    public void postCrawling(CrawlSession session, ExitNotifier.ExitStatus status) {
        StateFlowGraph stateFlowGraph = session.getStateFlowGraph();
        this.allStatesHaveOneOreMoreIncomingEdges(stateFlowGraph);
        this.allEdgesConnectTwoStates(stateFlowGraph);
    }

    private void allStatesHaveOneOreMoreIncomingEdges(StateFlowGraph stateFlowGraph) {
        for (StateVertex state : stateFlowGraph.getAllStates()) {
            if (stateFlowGraph.getInitialState().getId() == state.getId()) continue;
            MatcherAssert.assertThat((Object)stateFlowGraph.getIncomingClickable(state).size(), (Matcher)Is.is((Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        }
    }

    private void allEdgesConnectTwoStates(StateFlowGraph stateFlowGraph) {
        for (Eventable eventable : stateFlowGraph.getAllEdges()) {
            MatcherAssert.assertThat((Object)eventable.getSourceStateVertex(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            MatcherAssert.assertThat((Object)eventable.getTargetStateVertex(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

