/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.ExitNotifier;
import com.crawljax.core.state.DefaultStateVertexFactory;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexFactory;
import com.crawljax.core.state.StateVertexImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.jgrapht.GraphPath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateFlowGraphTest {
    private StateVertex index;
    private StateVertex state2;
    private StateVertex state3;
    private StateVertex state4;
    private StateVertex state5;
    private InMemoryStateFlowGraph graph;

    @Before
    public void setup() {
        this.index = new StateVertexImpl(0, "index", "<table><div>index</div></table>");
        this.state2 = new StateVertexImpl(2, "STATE_TWO", "<table><div>state2</div></table>");
        this.state3 = new StateVertexImpl(3, "STATE_THREE", "<table><div>state3</div></table>");
        this.state4 = new StateVertexImpl(4, "STATE_FOUR", "<table><div>state4</div></table>");
        this.state5 = new StateVertexImpl(5, "STATE_FIVE", "<table><div>state5</div></table>");
        this.graph = new InMemoryStateFlowGraph(new ExitNotifier(0), (StateVertexFactory)new DefaultStateVertexFactory());
        this.graph.putIndex(this.index);
    }

    @Test
    public void testDuplicationAdding() {
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.index), (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state2), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state3), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state4), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state5), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state2, this.newXpathEventable("/body/div[4]")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state2, this.index, this.newXpathEventable("/body/div[89]")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state2, this.state3, this.newXpathEventable("/home/a")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state4, this.newXpathEventable("/body/div[2]/div")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state2, this.state5, this.newXpathEventable("/body/div[5]")));
        Assert.assertFalse((boolean)this.graph.addEdge(this.state2, this.state5, this.newXpathEventable("/body/div[5]")));
        ImmutableSet clickables = this.graph.getOutgoingClickables(this.state2);
        Assert.assertEquals((long)3L, (long)clickables.size());
        clickables = this.graph.getIncomingClickable(this.state2);
        Assert.assertTrue((clickables.size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.graph.toString());
        Assert.assertEquals((long)this.state2.hashCode(), (long)this.state2.hashCode());
        Assert.assertTrue((boolean)this.state2.equals(new StateVertexImpl(2, "STATE_2", "<table><div>state2</div></table>")));
        Assert.assertTrue((boolean)this.graph.canGoTo(this.state2, this.state3));
        Assert.assertTrue((boolean)this.graph.canGoTo(this.state2, this.state5));
        Assert.assertFalse((boolean)this.graph.canGoTo(this.state2, this.state4));
        Assert.assertTrue((boolean)this.graph.canGoTo(this.state2, this.index));
        ImmutableList list = this.graph.getShortestPath(this.index, this.state3);
        Assert.assertEquals((long)list.size(), (long)2L);
        Eventable c = (Eventable)list.get(0);
        Assert.assertEquals((Object)c.getIdentification().getValue(), (Object)"/body/div[4]");
        c = (Eventable)list.get(1);
        Assert.assertEquals((Object)c.getIdentification().getValue(), (Object)"/home/a");
        StateVertexImpl hold = new StateVertexImpl(0, this.index.getName(), this.index.getDom());
        list = this.graph.getShortestPath((StateVertex)hold, this.state3);
        Assert.assertEquals((long)list.size(), (long)2L);
        ImmutableSet states = this.graph.getOutgoingStates(this.index);
        Assert.assertTrue((states.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)states.contains(this.state2));
        Assert.assertTrue((boolean)states.contains(this.state4));
        Assert.assertFalse((boolean)states.contains(this.state3));
        ImmutableSet allStates = this.graph.getAllStates();
        Assert.assertTrue((allStates.size() == 5 ? 1 : 0) != 0);
    }

    private Eventable newXpathEventable(String xPath) {
        return new Eventable(new Identification(Identification.How.xpath, xPath), Eventable.EventType.click);
    }

    @Test
    public void testCloneStates() {
        StateVertexImpl state3clone2 = new StateVertexImpl(3, "STATE_THREE", "<table><div>state2</div></table>");
        Assert.assertTrue((this.graph.putIfAbsent(this.state2) == null ? 1 : 0) != 0);
        Assert.assertTrue((this.graph.putIfAbsent(this.state4) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state2, this.newXpathEventable("/body/div[4]")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state4, (StateVertex)state3clone2, new Eventable(new Identification(Identification.How.xpath, "/home/a"), Eventable.EventType.click)));
    }

    @Test
    public void testGetMeanStateStringSize() {
        String HTML1 = "<SCRIPT src='js/jquery-1.2.1.js' type='text/javascript'></SCRIPT> <SCRIPT src='js/jquery-1.2.3.js' type='text/javascript'></SCRIPT><body><div id='firstdiv' class='orange'></div><div><span id='thespan'><a id='thea'>test</a></span></div></body>";
        String HTML2 = "<SCRIPT src='js/jquery-1.2.1.js' type='text/javascript'></SCRIPT> <SCRIPT src='js/jquery-1.2.3.js' type='text/javascript'></SCRIPT><body><div id='firstdiv' class='orange'>";
        InMemoryStateFlowGraph g = new InMemoryStateFlowGraph(new ExitNotifier(0), (StateVertexFactory)new DefaultStateVertexFactory());
        g.putIndex((StateVertex)new StateVertexImpl(1, "", HTML1));
        g.putIfAbsent((StateVertex)new StateVertexImpl(2, "", HTML2));
        Assert.assertEquals((long)206L, (long)g.getMeanStateStringSize());
    }

    @Test
    public void testDoubleEvents() {
        Eventable c1 = this.newXpathEventable("/body/div[4]");
        Eventable c2 = this.newXpathEventable("/body/div[4]/div[2]");
        this.graph.putIfAbsent(this.index);
        this.graph.putIfAbsent(this.state2);
        this.graph.addEdge(this.index, this.state2, c1);
        this.graph.addEdge(this.index, this.state2, c2);
        Assert.assertEquals((long)2L, (long)this.graph.getAllEdges().size());
    }

    @Test
    public void testEdges() {
        Assert.assertTrue((this.graph.putIfAbsent(this.state2) == null ? 1 : 0) != 0);
        Assert.assertTrue((this.graph.putIfAbsent(this.state3) == null ? 1 : 0) != 0);
        Assert.assertTrue((this.graph.putIfAbsent(this.state4) == null ? 1 : 0) != 0);
        Eventable e1 = this.newXpathEventable("/4/index");
        Eventable e2 = this.newXpathEventable("/4/index");
        Eventable e3 = this.newXpathEventable("/4/index");
        Eventable e4 = this.newXpathEventable("/5/index");
        Eventable e5 = this.newXpathEventable("/4/index");
        Eventable e6 = this.newXpathEventable("/5/index");
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state2, e1));
        Assert.assertFalse((boolean)this.graph.addEdge(this.index, this.state2, e1));
        Assert.assertFalse((boolean)this.graph.addEdge(this.index, this.state2, e3));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state2, this.state3, e2));
        Assert.assertFalse((boolean)this.graph.addEdge(this.state2, this.state3, e1));
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state4, e3));
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state4, e4));
        Assert.assertFalse((boolean)this.graph.addEdge(this.index, this.state4, e5));
        Assert.assertFalse((boolean)this.graph.addEdge(this.index, this.state4, e6));
    }

    @Test
    public void whenStateAddedTheGraphCounterIsIncremented() {
        MatcherAssert.assertThat((Object)this.graph.getNumberOfStates(), (Matcher)Is.is((Object)1));
        this.graph.putIfAbsent(this.state2);
        MatcherAssert.assertThat((Object)this.graph.getNumberOfStates(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testAllPossiblePaths() {
        this.graph.putIfAbsent(this.state2);
        this.graph.putIfAbsent(this.state3);
        this.graph.putIfAbsent(this.state4);
        this.graph.putIfAbsent(this.state5);
        this.graph.addEdge(this.index, this.state2, this.newXpathEventable("/index/2"));
        this.graph.addEdge(this.state2, this.index, this.newXpathEventable("/2/index"));
        this.graph.addEdge(this.state2, this.state3, this.newXpathEventable("/2/3"));
        this.graph.addEdge(this.index, this.state4, this.newXpathEventable("/index/4"));
        this.graph.addEdge(this.state2, this.state5, this.newXpathEventable("/2/5"));
        this.graph.addEdge(this.state4, this.index, this.newXpathEventable("/4/index"));
        this.graph.addEdge(this.index, this.state5, this.newXpathEventable("/index/5"));
        this.graph.addEdge(this.state4, this.state2, this.newXpathEventable("/4/2"));
        this.graph.addEdge(this.state3, this.state5, this.newXpathEventable("/3/5"));
        this.graph.addEdge(this.state3, this.state4, this.newXpathEventable("/3/4"));
        List results = this.graph.getAllPossiblePaths(this.index);
        Assert.assertEquals((long)2L, (long)results.size());
        List p = (List)results.get(0);
        Assert.assertEquals((long)5L, (long)p.size());
        GraphPath e = (GraphPath)p.get(0);
        Assert.assertEquals((long)1L, (long)e.getEdgeList().size());
        p = (List)results.get(1);
        Assert.assertEquals((long)2L, (long)p.size());
    }

    @Test
    public void largestTest() {
        this.graph.putIfAbsent(this.state2);
        this.graph.putIfAbsent(this.state3);
        this.graph.putIfAbsent(this.state4);
        this.graph.putIfAbsent(this.state5);
        this.graph.addEdge(this.index, this.state2, this.newXpathEventable("/index/2"));
        this.graph.addEdge(this.state2, this.index, this.newXpathEventable("/2/index"));
        this.graph.addEdge(this.state2, this.state3, this.newXpathEventable("/2/3"));
        this.graph.addEdge(this.index, this.state4, this.newXpathEventable("/index/4"));
        this.graph.addEdge(this.state2, this.state5, this.newXpathEventable("/2/5"));
        this.graph.addEdge(this.state4, this.index, this.newXpathEventable("/4/index"));
        this.graph.addEdge(this.index, this.state5, this.newXpathEventable("/index/5"));
        this.graph.addEdge(this.state4, this.state2, this.newXpathEventable("/4/2"));
        this.graph.addEdge(this.state3, this.state5, this.newXpathEventable("/3/5"));
        this.graph.addEdge(this.state3, this.state4, this.newXpathEventable("/3/4"));
        List results = this.graph.getAllPossiblePaths(this.index);
        MatcherAssert.assertThat((Object)results, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)((List)results.get(0)), (Matcher)IsCollectionWithSize.hasSize((int)5));
        MatcherAssert.assertThat((Object)((GraphPath)((List)results.get(0)).get(0)).getEdgeList(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((List)results.get(1)), (Matcher)IsCollectionWithSize.hasSize((int)2));
        HashSet<Eventable> uEvents = new HashSet<Eventable>();
        for (List paths : results) {
            for (GraphPath p : paths) {
                for (Eventable edge : p.getEdgeList()) {
                    if (uEvents.contains(edge)) continue;
                    uEvents.add(edge);
                }
            }
        }
    }
}

