/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.codahale.metrics.MetricRegistry;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.invariant.Invariant;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.state.DefaultStateVertexFactory;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateMachine;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexFactory;
import com.crawljax.core.state.StateVertexImpl;
import com.crawljax.oraclecomparator.StateComparator;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StateMachineTest {
    private static boolean hit = false;
    private final StateVertex index = new StateVertexImpl(0, "index", "<table><div>index</div></table>");
    private StateMachine sm;
    @Mock
    private EmbeddedBrowser dummyBrowser;
    @Mock
    private StateComparator comparator;
    @Mock
    private CrawlSession session;
    @Mock
    private CrawlerContext context;
    @Mock
    private Plugins plugins;

    @Before
    public void initStateMachine() {
        InMemoryStateFlowGraph sfg = this.newStateFlowGraph();
        this.sm = new StateMachine(sfg, ImmutableList.of(), this.plugins, this.comparator, new ArrayList());
    }

    @Test
    public void testInitOk() {
        Assert.assertNotNull((Object)this.sm);
        Assert.assertNotNull((Object)this.sm.getCurrentState());
        Assert.assertEquals((Object)this.sm.getCurrentState(), (Object)this.index);
    }

    @Test
    public void testChangeState() {
        StateVertexImpl state2 = new StateVertexImpl(2, "state2", "<table><div>state2</div></table>");
        Assert.assertFalse((boolean)this.sm.changeState((StateVertex)state2));
        Assert.assertNotSame((Object)this.sm.getCurrentState(), (Object)state2);
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertTrue((boolean)this.sm.switchToStateAndCheckIfClone(c, (StateVertex)state2, this.context));
        Assert.assertEquals((Object)this.sm.getCurrentState(), (Object)state2);
        Assert.assertTrue((boolean)this.sm.changeState(this.index));
        Assert.assertEquals((Object)this.sm.getCurrentState(), (Object)this.index);
    }

    @Test
    public void testCloneState() {
        StateVertexImpl state2 = new StateVertexImpl(2, "state2", "<table><div>state2</div></table>");
        StateVertexImpl state3 = new StateVertexImpl(3, "state3", "<table><div>state2</div></table>");
        Assert.assertFalse((boolean)this.sm.changeState((StateVertex)state2));
        Assert.assertNotSame((Object)this.sm.getCurrentState(), (Object)state2);
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertTrue((boolean)this.sm.switchToStateAndCheckIfClone(c, (StateVertex)state2, this.context));
        Assert.assertFalse((boolean)this.sm.changeState((StateVertex)state2));
        Assert.assertSame((Object)this.sm.getCurrentState(), (Object)state2);
        Assert.assertEquals((String)"state2 equals state3", (Object)state2, (Object)state3);
        Assert.assertNotSame((String)"state2 != state3", (Object)state2, (Object)state3);
        Eventable c2 = new Eventable(new Identification(Identification.How.xpath, "/bla2"), Eventable.EventType.click);
        Assert.assertFalse((boolean)this.sm.switchToStateAndCheckIfClone(c2, (StateVertex)state3, this.context));
        Assert.assertEquals((String)"state2 equals state3", (Object)state2, (Object)state3);
        Assert.assertSame((String)"state2 == state3", (Object)state2, (Object)this.sm.getCurrentState());
    }

    @Test
    public void testRewind() {
        StateVertexImpl state2 = new StateVertexImpl(2, "state2", "<table><div>state2</div></table>");
        StateVertexImpl state3 = new StateVertexImpl(3, "state3", "<table><div>state2</div></table>");
        StateVertexImpl state4 = new StateVertexImpl(4, "state4", "<table><div>state4</div></table>");
        Assert.assertFalse((boolean)this.sm.changeState((StateVertex)state2));
        Assert.assertNotSame((Object)this.sm.getCurrentState(), (Object)state2);
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertTrue((boolean)this.sm.switchToStateAndCheckIfClone(c, (StateVertex)state2, this.context));
        Assert.assertFalse((boolean)this.sm.changeState((StateVertex)state2));
        Assert.assertSame((Object)this.sm.getCurrentState(), (Object)state2);
        Assert.assertEquals((String)"state2 equals state3", (Object)state2, (Object)state3);
        Assert.assertFalse((String)"state2 not equals state4", (boolean)state2.equals(state4));
        Eventable c2 = new Eventable(new Identification(Identification.How.xpath, "/bla2"), Eventable.EventType.click);
        Assert.assertFalse((boolean)this.sm.switchToStateAndCheckIfClone(c2, (StateVertex)state3, this.context));
        Eventable c3 = new Eventable(new Identification(Identification.How.xpath, "/bla2"), Eventable.EventType.click);
        Assert.assertTrue((boolean)this.sm.switchToStateAndCheckIfClone(c3, (StateVertex)state4, this.context));
        this.sm.rewind();
        Assert.assertEquals((String)"CurrentState == index", (Object)this.index, (Object)this.sm.getCurrentState());
        Assert.assertTrue((boolean)this.sm.changeState((StateVertex)state2));
        Assert.assertTrue((boolean)this.sm.changeState((StateVertex)state2));
        Assert.assertTrue((boolean)this.sm.changeState((StateVertex)state4));
        this.sm.rewind();
        Assert.assertEquals((String)"CurrentState == index", (Object)this.index, (Object)this.sm.getCurrentState());
        Assert.assertFalse((boolean)this.sm.changeState((StateVertex)state4));
    }

    @Test
    public void testInvariants() {
        StateVertexImpl state2 = new StateVertexImpl(2, "state2", "<table><div>state2</div></table>");
        StateVertexImpl state3 = new StateVertexImpl(3, "state3", "<table><div>state2</div></table>");
        hit = false;
        ImmutableList iList = ImmutableList.of((Object)new Invariant("Test123", browser -> {
            hit = true;
            return false;
        }));
        InMemoryStateFlowGraph sfg = this.newStateFlowGraph();
        StateMachine smLocal = new StateMachine(sfg, iList, this.plugins, this.comparator, new ArrayList());
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertTrue((boolean)smLocal.switchToStateAndCheckIfClone(c, (StateVertex)state2, this.context));
        Assert.assertTrue((String)"Invariants are executed", (boolean)hit);
        hit = false;
        Assert.assertFalse((String)"Hit reset", (boolean)hit);
        Eventable c2 = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertFalse((boolean)smLocal.switchToStateAndCheckIfClone(c2, (StateVertex)state3, this.context));
        Assert.assertTrue((String)"Invariants are executed", (boolean)hit);
    }

    private InMemoryStateFlowGraph newStateFlowGraph() {
        InMemoryStateFlowGraph sfg = new InMemoryStateFlowGraph(new ExitNotifier(0), (StateVertexFactory)new DefaultStateVertexFactory());
        sfg.putIndex(this.index);
        return sfg;
    }

    @Test
    public void testOnNewStatePlugin() {
        hit = false;
        CrawljaxConfiguration config = CrawljaxConfiguration.builderFor((String)"http://localhost").addPlugin(new Plugin[]{(context, state) -> {
            hit = true;
        }}).build();
        this.setStateMachineForConfig(config);
        StateVertexImpl state2 = new StateVertexImpl(2, "state2", "<table><div>state2</div></table>");
        StateVertexImpl state3 = new StateVertexImpl(3, "state3", "<table><div>state2</div></table>");
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertTrue((boolean)this.sm.switchToStateAndCheckIfClone(c, (StateVertex)state2, this.context));
        Assert.assertTrue((String)"Plugins are executed", (boolean)hit);
        hit = false;
        Assert.assertFalse((String)"Hit reset", (boolean)hit);
        Eventable c2 = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertFalse((boolean)this.sm.switchToStateAndCheckIfClone(c2, (StateVertex)state3, this.context));
        Assert.assertFalse((String)"Plugins are NOT executed", (boolean)hit);
    }

    private void setStateMachineForConfig(CrawljaxConfiguration config) {
        this.sm = new StateMachine(this.newStateFlowGraph(), config.getCrawlRules().getInvariants(), new Plugins(config, new MetricRegistry()), this.comparator, new ArrayList());
    }

    @Test
    public void testInvariantFailurePlugin() {
        hit = false;
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((String)"http://localhost").addPlugin(new Plugin[]{(invariant, context) -> {
            hit = true;
        }});
        builder.crawlRules().addInvariant(new Invariant[]{new Invariant("Test123", browser -> false)});
        this.setStateMachineForConfig(builder.build());
        StateVertexImpl state2 = new StateVertexImpl(2, "state2", "<table><div>state2</div></table>");
        StateVertexImpl state3 = new StateVertexImpl(3, "state3", "<table><div>state2</div></table>");
        Eventable c = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertTrue((boolean)this.sm.switchToStateAndCheckIfClone(c, (StateVertex)state2, this.context));
        Assert.assertTrue((String)"InvariantViolationPlugin are executed", (boolean)hit);
        hit = false;
        Assert.assertFalse((String)"Hit reset", (boolean)hit);
        Eventable c2 = new Eventable(new Identification(Identification.How.xpath, "/bla"), Eventable.EventType.click);
        Assert.assertFalse((boolean)this.sm.switchToStateAndCheckIfClone(c2, (StateVertex)state3, this.context));
        Assert.assertTrue((String)"InvariantViolationPlugin are executed", (boolean)hit);
    }
}

