/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexFactory;
import com.crawljax.core.state.StateVertexImpl;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class StateVertexFactoryTest {
    @ClassRule
    public static final RunWithWebServer SERVER = new RunWithWebServer("/site");

    @Test
    public void whenStateVertexFactoryDefinedItIsUsedToCompareStates() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = SERVER.newConfigBuilder("infinite.html");
        builder.setStateVertexFactory(new StateVertexFactory(){

            public StateVertex newStateVertex(int id, String url, String name, String dom, String strippedDom, EmbeddedBrowser browser) {
                return new StateVertexImpl(id, url, name, dom, strippedDom){
                    private static final long serialVersionUID = 8037922282301084581L;

                    public int hashCode() {
                        return 1;
                    }

                    public boolean equals(Object object) {
                        return true;
                    }
                };
            }
        });
        int depth = 3;
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        CrawljaxRunner runner = new CrawljaxRunner(builder.setMaximumDepth(depth).build());
        CrawlSession session = runner.call();
        MatcherAssert.assertThat((Object)session.getStateFlowGraph(), StateFlowGraphMatchers.hasStates(1));
        MatcherAssert.assertThat((Object)runner.getReason(), (Matcher)Is.is((Object)ExitNotifier.ExitStatus.EXHAUSTED));
    }
}

