/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexImpl;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateVertexTest {
    String HTML = "<SCRIPT src='js/jquery-1.2.1.js' type='text/javascript'></SCRIPT> <SCRIPT src='js/jquery-1.2.3.js' type='text/javascript'></SCRIPT><body><div id='firstdiv' class='orange'></div><div><span id='thespan'><a id='thea'>test</a></span></div></body>";
    private StateVertex s;
    private String name;
    private String dom;

    @Before
    public void setUp() {
        this.name = "index";
        this.dom = "<body></body>";
        this.s = new StateVertexImpl(0, this.name, this.dom);
    }

    @Test
    public void testHashCode() {
        StateVertexImpl state = new StateVertexImpl(1, "foo", this.dom);
        StateVertexImpl temp = new StateVertexImpl(2, this.name, this.dom);
        Assert.assertEquals((long)temp.hashCode(), (long)state.hashCode());
    }

    @Test
    public void testStateVertexString() {
        StateVertexImpl sv = new StateVertexImpl(2, this.name, "");
        Assert.assertNotNull((Object)sv);
    }

    @Test
    public void testStateVertexStringString() {
        Assert.assertNotNull((Object)this.s);
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)this.name, (Object)this.s.getName());
    }

    @Test
    public void testGetDom() {
        Assert.assertEquals((Object)this.dom, (Object)this.s.getDom());
    }

    @Test
    public void testEqualsObject() {
        StateVertexImpl stateEqual = new StateVertexImpl(1, "foo", this.dom);
        StateVertexImpl stateNotEqual = new StateVertexImpl(2, "foo", "<table><div>bla</div</table>");
        StateVertexImpl sv = new StateVertexImpl(1, this.name, this.dom);
        Assert.assertTrue((boolean)stateEqual.equals(sv));
        Assert.assertFalse((boolean)stateNotEqual.equals(sv));
        Assert.assertFalse((boolean)stateEqual.equals(null));
        Assert.assertFalse((boolean)stateEqual.equals(new Eventable(new Identification(Identification.How.xpath, "/body/div[3]/a"), Eventable.EventType.click)));
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)this.s.toString());
    }

    @Test
    public void testGetDomSize() {
        StateVertexImpl sv = new StateVertexImpl(1, "test", this.HTML);
        int count = sv.getDom().getBytes().length;
        Assert.assertEquals((long)242L, (long)count);
    }

    @Test
    public void testSerializability() {
        StateVertexImpl sv = new StateVertexImpl(2, "testSerliazibility", this.HTML);
        byte[] serializedSv = SerializationUtils.serialize((Serializable)sv);
        StateVertex deserializedSv = (StateVertex)SerializationUtils.deserialize((byte[])serializedSv);
        MatcherAssert.assertThat((Object)deserializedSv, (Matcher)CoreMatchers.equalTo((Object)sv));
        MatcherAssert.assertThat((Object)deserializedSv.getName(), (Matcher)CoreMatchers.is((Object)sv.getName()));
        MatcherAssert.assertThat((Object)deserializedSv.getDom(), (Matcher)CoreMatchers.is((Object)sv.getDom()));
    }
}

