/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core.state;

import com.crawljax.core.CrawlSession;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.StateVertex;
import com.crawljax.test.BaseCrawler;
import com.crawljax.test.BrowserTest;
import com.google.common.collect.ImmutableSet;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class StatesContainElementsTest {
    private CrawlSession crawl;

    @Before
    public void setup() {
        this.crawl = new BaseCrawler(Resource.newClassPathResource((String)"demo-site")){

            @Override
            protected CrawljaxConfiguration.CrawljaxConfigurationBuilder newCrawlConfigurationBuilder() {
                return super.newCrawlConfigurationBuilder().setMaximumStates(2);
            }
        }.crawl();
    }

    @Test
    public void whenCrawledTheStateVertexesContainEvents() {
        ImmutableSet allStates = this.crawl.getStateFlowGraph().getAllStates();
        for (StateVertex stateVertex : allStates) {
            if (!"index".equals(stateVertex.getName())) continue;
            MatcherAssert.assertThat((Object)stateVertex.getCandidateElements(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsEmptyCollection.empty())));
        }
    }
}

