/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.crawls;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.BrowserOptions;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.test.BaseCrawler;
import com.crawljax.test.BrowserTest;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class CrawlClickablesTest {
    @Test
    public void testCrawlWithClickableDetection() {
        CrawlSession crawl = new BaseCrawler("clickable"){

            @Override
            public CrawljaxConfiguration.CrawljaxConfigurationBuilder newCrawlConfigurationBuilder() {
                CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = super.newCrawlConfigurationBuilder();
                builder.crawlRules().clickElementsWithClickEventHandler();
                builder.crawlRules().clickOnce(true);
                BrowserOptions options = new BrowserOptions();
                options.setUSE_CDP(true);
                BrowserConfiguration browserConfiguration = new BrowserConfiguration(EmbeddedBrowser.BrowserType.CHROME_HEADLESS, 1, options);
                builder.setBrowserConfig(browserConfiguration);
                return builder;
            }
        }.crawl();
        StateFlowGraph stateFlowGraph = crawl.getStateFlowGraph();
        int numStates = 2;
        MatcherAssert.assertThat((Object)stateFlowGraph, StateFlowGraphMatchers.hasStates(numStates));
    }
}

