/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.crawls;

import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.test.BaseCrawler;
import com.crawljax.test.BrowserTest;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class CrawlHiddenElementsTest {
    @Test
    public void testHiddenElementsSiteCrawl() {
        CrawlSession crawl = new BaseCrawler("hidden-elements-site"){

            @Override
            public CrawljaxConfiguration.CrawljaxConfigurationBuilder newCrawlConfigurationBuilder() {
                CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = super.newCrawlConfigurationBuilder();
                builder.crawlRules().crawlHiddenAnchors(true);
                return builder;
            }
        }.crawl();
        StateFlowGraph stateFlowGraph = crawl.getStateFlowGraph();
        int withIssue97 = 2;
        MatcherAssert.assertThat((Object)stateFlowGraph, StateFlowGraphMatchers.hasStates(withIssue97));
    }

    @Test
    public void whenHiddenElementsOfItShouldNotCrawl() {
        CrawlSession crawl = new BaseCrawler("hidden-elements-site").crawl();
        StateFlowGraph stateFlowGraph = crawl.getStateFlowGraph();
        int expectedStates = 1;
        MatcherAssert.assertThat((Object)stateFlowGraph, StateFlowGraphMatchers.hasStates(expectedStates));
    }
}

