/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.crawls;

import com.crawljax.core.CrawlSession;
import com.crawljax.core.configuration.CrawlScope;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.StateVertex;
import com.crawljax.test.BaseCrawler;
import com.crawljax.test.BrowserTest;
import java.net.URI;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public class CrawlWithCustomScopeTest {
    @Test
    public void crawlsPagesOnlyInCustomScope() throws Exception {
        final CrawlScope crawlScope = url -> url.contains("in_scope") || url.endsWith("crawlscope/index.html");
        BaseCrawler baseCrawler = new BaseCrawler("crawlscope"){

            @Override
            public CrawljaxConfiguration.CrawljaxConfigurationBuilder newCrawlConfigurationBuilder() {
                CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = super.newCrawlConfigurationBuilder();
                builder.setCrawlScope(crawlScope);
                return builder;
            }
        };
        CrawlSession crawlSession = baseCrawler.crawl();
        URI baseUrl = baseCrawler.getWebServer().getSiteUrl();
        HashSet<String> crawledUrls = new HashSet<String>();
        for (StateVertex state : crawlSession.getStateFlowGraph().getAllStates()) {
            crawledUrls.add(state.getUrl());
        }
        MatcherAssert.assertThat(crawledUrls, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{baseUrl + "crawlscope", baseUrl + "crawlscope/in_scope.html", baseUrl + "crawlscope/in_scope_inner.html"}));
        MatcherAssert.assertThat((Object)crawledUrls.size(), (Matcher)Is.is((Object)3));
    }
}

