/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.forms;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.configuration.Form;
import com.crawljax.core.configuration.InputSpecification;
import com.crawljax.core.state.Identification;
import com.crawljax.forms.FormHandler;
import com.crawljax.forms.FormInput;
import com.crawljax.forms.FormInputValueHelper;
import com.crawljax.forms.InputValue;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.WebElement;

@Category(value={BrowserTest.class})
public class FormHandlerTest {
    @ClassRule
    public static final RunWithWebServer DEMO_SITE_SERVER = new RunWithWebServer("/site/formhandler");
    @Rule
    public final BrowserProvider provider = new BrowserProvider();
    private EmbeddedBrowser browser;
    private FormHandler formHandler;

    @Before
    public void setup() throws Exception {
        this.browser = this.provider.newEmbeddedBrowser();
        this.browser.goToUrl(DEMO_SITE_SERVER.getSiteUrl());
        FormInputValueHelper.reset();
    }

    @Test
    public void shouldSetValueIntoTextField() throws Exception {
        String fieldName = "name";
        String fieldValue = "Some Name";
        this.formHandler = new FormHandler(this.browser, FormHandlerTest.crawlRulesWithField(fieldName, FormHandlerTest.setOf(fieldValue)));
        WebElement nameField = FormHandlerTest.getFieldById(this.browser, fieldName);
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)""));
        this.formHandler.handleFormElements(this.formHandler.getFormInputs());
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)fieldValue));
    }

    @Test
    public void shouldSetFirstValueIntoTextFieldEvenIfManyValuesSpecified() throws Exception {
        String fieldName = "name";
        Set<InputValue> values = FormHandlerTest.setOf("Some Name", "another value", "...");
        String fieldValue = values.iterator().next().getValue();
        this.formHandler = new FormHandler(this.browser, FormHandlerTest.crawlRulesWithField(fieldName, values));
        WebElement nameField = FormHandlerTest.getFieldById(this.browser, fieldName);
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)""));
        this.formHandler.handleFormElements(this.formHandler.getFormInputs());
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)fieldValue));
    }

    @Test
    public void shouldClearTextFieldBeforeSettingValue() throws Exception {
        String fieldName = "name";
        String fieldValue = "Some Name";
        this.formHandler = new FormHandler(this.browser, FormHandlerTest.crawlRulesWithField(fieldName, FormHandlerTest.setOf(fieldValue)));
        WebElement nameField = FormHandlerTest.getFieldById(this.browser, fieldName);
        nameField.sendKeys(new CharSequence[]{"Not Empty"});
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)"Not Empty"));
        this.formHandler.handleFormElements(this.formHandler.getFormInputs());
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)fieldValue));
    }

    @Test
    public void shouldNotSetValueToTextFieldIfNotFoundAndRandomIsDisabled() throws Exception {
        String fieldName = "fieldNotFound";
        this.formHandler = new FormHandler(this.browser, FormHandlerTest.crawlRulesWithField(fieldName, FormHandlerTest.setOf("value")));
        WebElement nameField = FormHandlerTest.getFieldById(this.browser, "name");
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)""));
        this.formHandler.handleFormElements(this.formHandler.getFormInputs());
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldSetRandomValueToTextFieldIfNotFoundAndRandomIsEnabled() throws Exception {
        String fieldName = "fieldNotFound";
        this.formHandler = new FormHandler(this.browser, FormHandlerTest.crawlRulesWithFieldAndRandom(fieldName, FormHandlerTest.setOf("value")));
        WebElement nameField = FormHandlerTest.getFieldById(this.browser, "name");
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Object)""));
        this.formHandler.handleFormElements(this.formHandler.getFormInputs());
        Assert.assertThat((Object)FormHandlerTest.value(nameField), (Matcher)Is.is((Matcher)IsNot.not((Object)"")));
    }

    private static String value(WebElement field) {
        return field.getAttribute("value");
    }

    private static CrawlRules crawlRulesWithField(String name, Set<InputValue> values) {
        return FormHandlerTest.crawlRulesWithField(false, name, values);
    }

    private static CrawlRules crawlRulesWithField(boolean random, String name, Set<InputValue> values) {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((URI)DEMO_SITE_SERVER.getSiteUrl());
        InputSpecification inputSpec = new InputSpecification();
        Form form = new Form();
        form.inputField(FormInput.InputType.TEXT, new Identification(Identification.How.id, name)).inputValues(values);
        inputSpec.setValuesInForm(form);
        builder.crawlRules().setFormFillMode(random ? CrawlRules.FormFillMode.RANDOM : CrawlRules.FormFillMode.NORMAL).setInputSpec(inputSpec);
        return builder.build().getCrawlRules();
    }

    private static CrawlRules crawlRulesWithFieldAndRandom(String name, Set<InputValue> values) {
        return FormHandlerTest.crawlRulesWithField(true, name, values);
    }

    private static WebElement getFieldById(EmbeddedBrowser browser, String id) {
        Identification fieldId = new Identification(Identification.How.id, id);
        return browser.getWebElement(fieldId);
    }

    private static Set<InputValue> setOf(String ... values) {
        HashSet<InputValue> set = new HashSet<InputValue>();
        if (values != null && values.length != 0) {
            for (String value : values) {
                set.add(new InputValue(value));
            }
        }
        return set;
    }
}

