/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.forms;

import com.crawljax.forms.RandomInputValueGenerator;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

public class RandomInputValueGeneratorTest {
    private static final int NUM_RAND_CHECKS = 1000;
    private static final int LENGTH_SHORT = 1;
    private static final int LENGTH_MEDIUM = 15;
    private static final int LENGTH_LONG = 150;
    private RandomInputValueGenerator generator;

    @Before
    public void setup() {
        this.generator = new RandomInputValueGenerator();
    }

    @Test
    public void randomValuesAreUnique() {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            MatcherAssert.assertThat((Object)set.add(this.generator.getRandomString(15)), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void testLengthSpecification() {
        MatcherAssert.assertThat((Object)this.generator.getRandomString(1).length(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.generator.getRandomString(15).length(), (Matcher)Is.is((Object)15));
        MatcherAssert.assertThat((Object)this.generator.getRandomString(150).length(), (Matcher)Is.is((Object)150));
    }

    @Test(expected=IllegalArgumentException.class)
    public void randomOptionDoesntAcceptEmptyLists() {
        this.generator.getRandomItem((List)Lists.newArrayList());
    }
}

