/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oracle;

import com.crawljax.oraclecomparator.Comparator;
import com.crawljax.oraclecomparator.comparators.AttributeComparator;
import com.crawljax.oraclecomparator.comparators.DateComparator;
import com.crawljax.oraclecomparator.comparators.EditDistanceComparator;
import com.crawljax.oraclecomparator.comparators.PlainStructureComparator;
import com.crawljax.oraclecomparator.comparators.RegexComparator;
import com.crawljax.oraclecomparator.comparators.ScriptComparator;
import com.crawljax.oraclecomparator.comparators.SimpleComparator;
import com.crawljax.oraclecomparator.comparators.StyleComparator;
import com.crawljax.oraclecomparator.comparators.XPathExpressionComparator;
import org.junit.Assert;
import org.junit.Test;

public class OracleTest {
    private void compareTwoDOMsWithComparatorEqual(String original, String newDom, Comparator comparator) {
        Assert.assertTrue((boolean)comparator.isEquivalent(original, newDom));
    }

    private void compareTwoDOMsWithComparatorNotEqual(String original, String newDom, Comparator comparator) {
        Assert.assertFalse((boolean)comparator.isEquivalent(original, newDom));
    }

    @Test
    public void testDateOracle() {
        DateComparator oracle = new DateComparator();
        this.compareTwoDOMsWithComparatorEqual("<HTML>Monday 15 march 1998</HTML>", "<HTML>Tuesday 13 december 2005</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>Monday 1 feb '98</HTML>", "<HTML>Wednesday 15 march '00</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>Friday 10 february</HTML>", "<HTML>Wednesday 3 march</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>28-12-1983</HTML>", "<HTML>15-3-1986</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>28.1.1976</HTML>", "<HTML>3.15.1986</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>1/1/2001</HTML>", "<HTML>30/12/1988</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>28-12-1983</HTML>", "<HTML>19-2-1986</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>28.1.1976</HTML>", "<HTML>3.15.1986</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>1/1/2001</HTML>", "<HTML>30/12/1988</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>28-12-'83</HTML>", "<HTML>19-1-'86</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>28.1.'76</HTML>", "<HTML>3.15.'86</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>1/1/'01</HTML>", "<HTML>30/12/'88</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>2003-16-03</HTML>", "<HTML>1986-3-3</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>1993.12.12</HTML>", "<HTML>1997.13.09</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>2013/1/3</HTML>", "<HTML>1986/3/3</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>19 november 1986</HTML>", "<HTML>18 june 1973</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>1th march 1986</HTML>", "<HTML>28th december 2005</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>15th november</HTML>", "<HTML>3th july</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>2003 March 15</HTML>", "<HTML>1978 july 5</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>2003Apr15</HTML>", "<HTML>1978jul5</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>March 2003</HTML>", "<HTML>October 1996</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>April '02</HTML>", "<HTML>August '99</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>April 19 2007</HTML>", "<HTML>January 1 1994</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>April 19, 2007</HTML>", "<HTML>January 1, 1994</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>April 4 '07</HTML>", "<HTML>January 1 '87</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>April 19, '66</HTML>", "<HTML>January 1, '88</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>4:47:00 am</HTML>", "<HTML>3:59:2PM</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>2:13pm</HTML>", "<HTML>3:59am</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML>14:17:29</HTML>", "<HTML>7:34:26</HTML>", (Comparator)oracle);
    }

    @Test
    public void testStyleOracle() {
        StyleComparator oracle = new StyleComparator();
        this.compareTwoDOMsWithComparatorEqual("<HTML><B>foo</B></HTML>", "<HTML>foo</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><PRE>foo</PRE></HTML>", "<HTML><STRONG>foo</STRONG></HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><FONT color=\"red\">foo</FONT> bar</HTML>", "<HTML>foo bar</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><FONT color=\"red\">foo</FONT> bar</HTML>", "<HTML><FONT color=\"green\">foo</FONT> bar</HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><SPAN width=\"100px\">foo</SPAN></HTML>", "<HTML><SPAN>foo</SPAN></HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><SPAN>foo</SPAN></HTML>", "<HTML><SPAN valign=\"top\">foo</SPAN></HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><SPAN style=\"color:  green;\">foo</SPAN></HTML>", "<HTML><SPAN style=\"color:red;\">foo</SPAN></HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><SPAN style=\"color: yellow\">foo</SPAN></HTML>", "<HTML><SPAN>foo</SPAN></HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual("<HTML><SPAN style=\"display:inline;color:red;\">foo</SPAN></HTML>", "<HTML><SPAN style=\"display:inline; color:green;\">foo</SPAN></HTML>", (Comparator)oracle);
        this.compareTwoDOMsWithComparatorNotEqual("<HTML><SPAN style=\"display:inline;color:red;\">foo</SPAN></HTML>", "<HTML><SPAN style=\"display:none; color:green;\">foo</SPAN></HTML>", (Comparator)oracle);
    }

    @Test
    public void testSimpleOracle() {
        SimpleComparator oracle = new SimpleComparator();
        this.compareTwoDOMsWithComparatorEqual("<HTML>\n\n<SPAN>\n    foo\n</SPAN></HTML>", "<HTML>\n<SPAN>\n    foo     \n\n</SPAN>\n</HTML>", (Comparator)oracle);
    }

    @Test
    public void testRegexOracle() {
        RegexComparator oracle = new RegexComparator(new String[]{"[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}"});
        this.compareTwoDOMsWithComparatorEqual("<HTML>192.168.1.1</HTML>", "<HTML>10.0.0.138</HTML>", (Comparator)oracle);
    }

    @Test
    public void testAttributeOracle() {
        String control = "<HTML><A href=\"foo.html\" myattr=\"true\">foo</A><HTML>";
        String test = "<HTML><A href=\"foo.html\" myattr=\"false\">foo</A><HTML>";
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new AttributeComparator(new String[]{"myattr"}));
    }

    @Test
    public void testPlainStructureOracle() {
        String control = "<HTML><A href=\"foo.html\" jquery12421421=\"bla\" myattr=\"true\">foo</A><HTML>";
        String test = "<HTML><A></A><HTML>";
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new PlainStructureComparator(true));
    }

    @Test
    public void testScriptComparator() {
        String control = "<HTML><head><script>JavaScript();</script><title>Test</title></head><body><script>JavaScript23();</script>test</body><HTML>";
        String test = "<HTML><head><title>Test</title></head><body>test</body><HTML>";
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new ScriptComparator());
    }

    @Test
    public void testEditDistanceComparator() {
        String control = "<HTML><head><title>Test</title></head><body>test</body><HTML>";
        String test = "<HTML><head><title>Test</title></head><body>test</body><HTML>";
        Assert.assertTrue((boolean)control.equals(test));
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new EditDistanceComparator(0.0));
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new EditDistanceComparator(1.0));
        test = "TheIsAlotOfRubish";
        this.compareTwoDOMsWithComparatorNotEqual(control, test, (Comparator)new EditDistanceComparator(1.0));
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new EditDistanceComparator(0.0));
        test = "<HTML><head></head><body>test</body><HTML>";
        EditDistanceComparator oracle = new EditDistanceComparator(0.5);
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)oracle);
        this.compareTwoDOMsWithComparatorNotEqual(control, test, (Comparator)new EditDistanceComparator(1.0));
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new EditDistanceComparator(0.0));
    }

    @Test
    public void testXPathExpressionComparator() {
        String control = "<HTML><head><title>Test</title></head><body>test</body><HTML>";
        String test = "<HTML><head><title>Test</title></head><body>test</body><HTML>";
        Assert.assertTrue((boolean)control.equals(test));
        XPathExpressionComparator oracle = new XPathExpressionComparator(new String[0]);
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)new XPathExpressionComparator(new String[0]));
        test = "<HTML><head><title>Test</title></head><body>test<div id='ignoreme'>ignoreme</div></body><HTML>";
        this.compareTwoDOMsWithComparatorNotEqual(control, test, (Comparator)oracle);
        this.compareTwoDOMsWithComparatorNotEqual(control, test, (Comparator)new XPathExpressionComparator(new String[0]));
        oracle = new XPathExpressionComparator(new String[]{"//*[@id='ignoreme']"});
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual(test, control, (Comparator)oracle);
        control = "<HTML><head><title>Test</title></head><body>test<div id='ignoreme'>ignoreme123</div></body><HTML>";
        this.compareTwoDOMsWithComparatorEqual(control, test, (Comparator)oracle);
        this.compareTwoDOMsWithComparatorEqual(test, control, (Comparator)oracle);
    }
}

