/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.oraclecomparator.comparators;

import com.crawljax.oraclecomparator.comparators.EditDistanceComparator;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditDistanceTest {
    private static final Logger LOG = LoggerFactory.getLogger(EditDistanceTest.class);
    private EditDistanceComparator comparator;

    @Before
    public void setup() {
        this.comparator = new EditDistanceComparator();
    }

    @Test
    public void testGetThreshold() {
        String x = "<form>bl</form>";
        String y = "<form>blabla</form>";
        double p = 0.8;
        double expected = (double)(2 * Math.max(x.length(), y.length())) * (1.0 - p);
        Assert.assertEquals((double)expected, (double)this.comparator.getThreshold(x, y, p), (double)0.01);
    }

    @Test
    public void testIsClone() {
        String x = "<form>BL</form>";
        String y = "<form>blabla</form>";
        LOG.debug(new LevenshteinDistance().apply((CharSequence)x, (CharSequence)y) + " Threshold: " + this.comparator.getThreshold(x, y, 0.7));
        Assert.assertTrue((boolean)this.comparator.isClone(x, y, 0.0));
        Assert.assertTrue((boolean)this.comparator.isClone(x, y, 0.5));
        Assert.assertTrue((boolean)this.comparator.isClone(x, y, 0.7));
        Assert.assertTrue((boolean)this.comparator.isClone(x, y, 0.75));
        Assert.assertTrue((boolean)this.comparator.isClone(x, y, 0.84));
        Assert.assertFalse((boolean)this.comparator.isClone(x, y, 0.89));
        Assert.assertFalse((boolean)this.comparator.isClone(x, y, 0.893));
        Assert.assertFalse((boolean)this.comparator.isClone(x, y, 0.9));
        Assert.assertFalse((boolean)this.comparator.isClone(x, y, 1.0));
        boolean arg = false;
        try {
            this.comparator.isClone(x, y, -2.0);
        }
        catch (IllegalArgumentException e) {
            arg = true;
        }
        Assert.assertTrue((boolean)arg);
        arg = false;
        try {
            this.comparator.isClone(x, y, 2.0);
        }
        catch (IllegalArgumentException e) {
            arg = true;
        }
        Assert.assertTrue((boolean)arg);
    }
}

