/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.stateabstractions.hybrid;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.StatePair;
import com.crawljax.core.state.StateVertex;
import com.crawljax.fragmentation.FragmentManager;
import com.crawljax.fragmentation.FragmentationPlugin;
import com.crawljax.stateabstractions.hybrid.FragGenStateVertexFactory;
import com.crawljax.test.WarchiveServer;
import com.google.common.base.Preconditions;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FragGenLivePageComparisonTests {
    @Rule
    public final BrowserProvider provider = new BrowserProvider();
    WarchiveServer server;
    EmbeddedBrowser browser;
    File TEST_OUTPUT_DIR = new File("testOutput");
    private FragGenStateVertexFactory factory;

    @Before
    public void setup() {
        if (!this.TEST_OUTPUT_DIR.exists()) {
            boolean created = this.TEST_OUTPUT_DIR.mkdir();
            Preconditions.checkArgument((boolean)created, (Object)"Could not create testOutput dir");
        }
        this.browser = this.provider.newEmbeddedBrowser();
    }

    public URI getUrl(String pagePart) throws URISyntaxException {
        return new URI(this.server.getSiteUrl().getScheme(), this.server.getSiteUrl().getUserInfo(), this.server.getSiteUrl().getHost(), this.server.getSiteUrl().getPort(), pagePart, null, null);
    }

    public void startServer(String warchDir) {
        this.server = new WarchiveServer("src/test/resources/warchives/" + warchDir, 8080);
        new Thread(this.server).start();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((String)"server not started properly", (boolean)this.server.getSiteUrl().toString().equalsIgnoreCase("http://localhost:8080/"));
    }

    public StateVertex getState(int id, URI url, EmbeddedBrowser browser, FragmentManager manager) {
        browser.goToUrl(url);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.factory = new FragGenStateVertexFactory(0.0, CrawljaxConfiguration.builderFor((URI)url), false);
        StateVertex state = this.factory.newStateVertex(id, browser.getCurrentUrl(), "state" + id, browser.getStrippedDom(), browser.getStrippedDomWithoutIframeContent(), browser);
        FragmentationPlugin.fragmentState((StateVertex)state, (FragmentManager)manager, (EmbeddedBrowser)browser, (File)this.TEST_OUTPUT_DIR, (boolean)true);
        return state;
    }

    @Test
    public void petclinicNDTests() throws URISyntaxException, InterruptedException {
        this.startServer("petclinic");
        URI url1 = this.getUrl("/replay/20230128041350/http://host.docker.internal:9966/petclinic/owners/2.html");
        URI url2 = this.getUrl("/replay/20230128041350/http://host.docker.internal:9966/petclinic/owners/10.html");
        FragmentManager fragmentManager = new FragmentManager(null);
        BrowserProvider provider = new BrowserProvider();
        StateVertex state1 = this.getState(0, url1, this.browser, fragmentManager);
        StateVertex state2 = this.getState(1, url2, this.browser, fragmentManager);
        StatePair.StateComparision comp = fragmentManager.cacheStateComparision(state1, state2, true);
        Assert.assertEquals((Object)StatePair.StateComparision.NEARDUPLICATE2, (Object)comp);
    }

    public void showPicture(BufferedImage state1Annotated, BufferedImage state1Annotated2) throws InterruptedException {
        JLabel picLabel = new JLabel(new ImageIcon(state1Annotated));
        final JFrame frame = new JFrame();
        frame.add(picLabel);
        frame.setSize(1200, 890);
        frame.setVisible(true);
        JLabel picLabel2 = new JLabel(new ImageIcon(state1Annotated2));
        final JFrame frame2 = new JFrame();
        frame2.add(picLabel2);
        frame2.setSize(1200, 890);
        frame2.setVisible(true);
        final Object lock = new Object();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    while (frame.isVisible() && frame2.isVisible()) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println("Closing!!");
                }
            }
        };
        t.start();
        frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent arg0) {
                Object object = lock;
                synchronized (object) {
                    frame.setVisible(false);
                    frame2.setVisible(false);
                    lock.notify();
                }
            }
        });
        t.join();
    }

    @After
    public void cleanup() {
        try {
            FileUtils.deleteDirectory((File)this.TEST_OUTPUT_DIR);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.server.stop();
        this.browser.close();
    }
}

