/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.stateabstractions.hybrid;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.eventablecondition.EventableConditionChecker;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CandidateElementExtractor;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.ExtractorManager;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StatePair;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexFactory;
import com.crawljax.forms.FormHandler;
import com.crawljax.fragmentation.FragmentManager;
import com.crawljax.fragmentation.FragmentationPlugin;
import com.crawljax.stateabstractions.hybrid.FragGenStateVertexFactory;
import com.crawljax.stateabstractions.hybrid.HybridStateVertexImpl;
import com.crawljax.util.DomUtils;
import com.google.common.collect.ImmutableList;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@RunWith(value=MockitoJUnitRunner.class)
public class FragGenTests {
    @Mock
    private Provider<InMemoryStateFlowGraph> graphProvider;
    @Mock
    private Provider<StateFlowGraph> sfgProvider;
    @Mock
    private EmbeddedBrowser browser;
    @Mock
    private ExtractorManager checker;
    @Mock
    private FormHandler handler;
    private InMemoryStateFlowGraph sfg;
    private Object LOG;
    private EventableConditionChecker eventableChecker;

    @Test
    public void testTreeDiffSimpleDOM() throws IOException {
        String docString = "<HTML><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></HEAD><BODY><SPAN id=\"testdiv\"> <a></a></SPAN><DIV style=\"colour:#FF0000\"><H>Header</H></DIV></BODY></HTML>";
        Document doc1 = DomUtils.asDocument((String)docString);
        String docString2 = "<HTML><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></HEAD><BODY><DIV id=\"testdiv\"> <a></a></DIV><DIV style=\"colour:#FF0000\"><H>Header</H></DIV></BODY></HTML>";
        Document doc2 = DomUtils.asDocument((String)docString2);
        double distance = HybridStateVertexImpl.computeDistance((Document)doc1, (Document)doc2, (boolean)false);
        Assert.assertEquals((double)distance, (double)1.0, (double)0.0);
        List differentNodes = HybridStateVertexImpl.getChangedNodes((Document)doc1, (Document)doc2, (boolean)false);
        List addedNodes = (List)differentNodes.get(0);
        List removedNodes = (List)differentNodes.get(1);
        Assert.assertTrue((boolean)((Node)addedNodes.get(0)).getNodeName().equalsIgnoreCase("span"));
        Assert.assertTrue((boolean)((Node)removedNodes.get(0)).getNodeName().equalsIgnoreCase("div"));
    }

    private void loadHybridState(String domString, StateVertex state, FragmentManager fragmentManager, File screenshotFile) throws IOException {
        BufferedImage screenshot = ImageIO.read(screenshotFile);
        FragmentationPlugin.loadFragmentState((StateVertex)state, (FragmentManager)fragmentManager, (Document)DomUtils.asDocument((String)domString), (BufferedImage)screenshot);
    }

    private CandidateElement getMatchingCandidate(List<CandidateElement> elements, String xpath) {
        CandidateElement element = null;
        for (CandidateElement elem : elements) {
            if (!elem.getIdentification().getValue().equalsIgnoreCase(xpath)) continue;
            element = elem;
        }
        return element;
    }

    @Test
    public void testCandidateAddition() throws IOException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder configBuilder = CrawljaxConfiguration.builderFor((String)"http://locahost/dummy.html");
        configBuilder.crawlRules().clickOnce(false);
        File state729 = new File("src/test/resources/crawls/frag_state610.html");
        File state802 = new File("src/test/resources/crawls/frag_state628.html");
        String docString1 = FileUtils.readFileToString((File)state729);
        String docString2 = FileUtils.readFileToString((File)state802);
        HybridStateVertexImpl state1 = new HybridStateVertexImpl(0, "", "index", docString1, docString1, 0.0, false);
        this.sfg = new InMemoryStateFlowGraph(new ExitNotifier(0), (StateVertexFactory)new FragGenStateVertexFactory(0.0, configBuilder, false));
        FragmentManager manager = new FragmentManager(this.graphProvider);
        File screenshot1 = new File("src/test/resources/crawls/state652.png");
        this.loadHybridState(docString1, (StateVertex)state1, manager, screenshot1);
        File screenshot2 = new File("src/test/resources/crawls/state653.png");
        Mockito.when((Object)this.checker.checkCrawlCondition(this.browser)).thenReturn((Object)true);
        this.eventableChecker = new EventableConditionChecker(configBuilder.build().getCrawlRules());
        Mockito.when((Object)this.checker.getEventableConditionChecker()).thenReturn((Object)this.eventableChecker);
        CandidateElementExtractor extractor = new CandidateElementExtractor(this.checker, this.browser, this.handler, configBuilder.build());
        ImmutableList elements = extractor.extract((StateVertex)state1);
        LinkedList<Object> results = new LinkedList<CandidateElement>();
        results.addAll((Collection<Object>)elements);
        state1.setElementsFound(results);
        Assert.assertEquals((String)"Wrong number of candidates found", (long)70L, (long)elements.size());
        CandidateElement element = this.getMatchingCandidate(results, "/HTML[1]/BODY[1]/TABLE[2]/TBODY[1]/TR[1]/TD[2]/FORM[1]/INPUT[2]");
        Assert.assertNotEquals((String)"A matching candidate should be found for '/HTML[1]/BODY[1]/TABLE[2]/TBODY[1]/TR[1]/TD[2]/FORM[1]/INPUT[2]'", null, (Object)element);
        Assert.assertTrue((String)"Element access should be recorded by fragment manager", (boolean)manager.recordAccess(element, (StateVertex)state1));
        HybridStateVertexImpl state2 = new HybridStateVertexImpl(1, "", "state1", docString2, docString2, 0.0, false);
        this.loadHybridState(docString2, (StateVertex)state2, manager, screenshot2);
        state1.equals((Object)state2);
        elements = extractor.extract((StateVertex)state2);
        results = new LinkedList();
        results.addAll((Collection<CandidateElement>)elements);
        Assert.assertEquals((String)"Wrong number of candidates found", (long)59L, (long)elements.size());
        state2.setElementsFound(results);
        CandidateElement element2 = this.getMatchingCandidate(results, "/HTML[1]/BODY[1]/TABLE[1]/TBODY[1]/TR[1]/TD[3]/FORM[1]/INPUT[1]");
        manager.setAccess((StateVertex)state2);
        Assert.assertTrue((String)"Access transfer should be done for new state", (boolean)state2.getRootFragment().isAccessTransferred());
        manager.recordAccess(element2, (StateVertex)state2);
        Assert.assertTrue((String)"element should be set to explored", (boolean)element2.wasExplored());
        StatePair.StateComparision comp = manager.cacheStateComparision((StateVertex)state2, (StateVertex)state1, true);
        Assert.assertEquals((String)"The two states are DIFFERENT", (Object)StatePair.StateComparision.DIFFERENT, (Object)comp);
    }

    @Test
    public void testFragGenComparisonND2() throws IOException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder configBuilder = CrawljaxConfiguration.builderFor((String)"http://locahost/dummy.html");
        File state729 = new File("src/test/resources/crawls/frag_state296.html");
        File state802 = new File("src/test/resources/crawls/frag_state297.html");
        String docString1 = FileUtils.readFileToString((File)state729);
        String docString2 = FileUtils.readFileToString((File)state802);
        HybridStateVertexImpl state1 = new HybridStateVertexImpl(0, "", "index", docString1, docString1, 0.0, false);
        HybridStateVertexImpl state2 = new HybridStateVertexImpl(1, "", "state1", docString2, docString2, 0.0, false);
        this.sfg = new InMemoryStateFlowGraph(new ExitNotifier(0), (StateVertexFactory)new FragGenStateVertexFactory(0.0, configBuilder, false));
        FragmentManager manager = new FragmentManager(this.graphProvider);
        File screenshot1 = new File("src/test/resources/crawls/state296.png");
        this.loadHybridState(docString1, (StateVertex)state1, manager, screenshot1);
        File screenshot2 = new File("src/test/resources/crawls/state297.png");
        this.loadHybridState(docString2, (StateVertex)state2, manager, screenshot2);
        Assert.assertFalse((String)"The two states are near-duplicates, not equal", (boolean)state1.equals((Object)state2));
        StatePair.StateComparision comp = manager.cacheStateComparision((StateVertex)state2, (StateVertex)state1, true);
        Assert.assertEquals((String)"The two states are NEAR_DUPLICATE2", (Object)StatePair.StateComparision.NEARDUPLICATE2, (Object)comp);
    }
}

