/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.stateabstractions.hybrid;

import com.crawljax.stateabstractions.hybrid.HybridStateVertexImpl;
import com.crawljax.util.DomUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@RunWith(value=Parameterized.class)
public class TreeDiffParamTest {
    private final String state1;
    private final String state2;
    private final Integer distance;
    private final String addedNode;
    private final String removedNode;

    public TreeDiffParamTest(String state1, String state2, Integer difference, String addedNode, String removedNode) {
        this.state1 = state1;
        this.state2 = state2;
        this.distance = difference;
        this.addedNode = addedNode;
        this.removedNode = removedNode;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"frag_state487.html", "frag_state408.html", 5, "#text", null}, {"frag_state487.html", "frag_state503.html", 2, "#text", null}, {"frag_state408.html", "frag_state503.html", 3, null, "input"});
    }

    @Test
    public void testTreeDiff() throws IOException {
        String docString = FileUtils.readFileToString((File)new File("src/test/resources/crawls/" + this.state1));
        Document doc1 = DomUtils.asDocument((String)docString);
        String docString2 = FileUtils.readFileToString((File)new File("src/test/resources/crawls/" + this.state2));
        Document doc2 = DomUtils.asDocument((String)docString2);
        double compDist = HybridStateVertexImpl.computeDistance((Document)doc1, (Document)doc2, (boolean)false);
        Assert.assertEquals((double)this.distance.intValue(), (double)compDist, (double)0.0);
        List differentNodes = HybridStateVertexImpl.getChangedNodes((Document)doc1, (Document)doc2, (boolean)false);
        List addedNodes = (List)differentNodes.get(0);
        List removedNodes = (List)differentNodes.get(1);
        if (this.addedNode != null) {
            Assert.assertTrue((boolean)((Node)addedNodes.get(0)).getNodeName().equalsIgnoreCase(this.addedNode));
        }
        if (this.removedNode != null) {
            Assert.assertTrue((boolean)((Node)removedNodes.get(0)).getNodeName().equalsIgnoreCase(this.removedNode));
        }
    }
}

