/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.stateabstractions.visual;

import com.crawljax.core.ExitNotifier;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.InMemoryStateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.core.state.StateVertexFactory;
import com.crawljax.stateabstractions.visual.imagehashes.DHashStateVertexFactory;
import com.crawljax.stateabstractions.visual.imagehashes.DHashStateVertexImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateFlowGraphVisualTest {
    private StateVertex index;
    private StateVertex state2;
    private StateVertex state3;
    private StateVertex state4;
    private StateVertex state5;
    private InMemoryStateFlowGraph graph;

    @Before
    public void setup() {
        this.index = new DHashStateVertexImpl(0, "index", "<table><div>index</div></table>", "001");
        this.state2 = new DHashStateVertexImpl(2, "STATE_TWO", "<table><div>state2</div></table>", "002");
        this.state3 = new DHashStateVertexImpl(3, "STATE_THREE", "<table><div>state3</div></table>", "003");
        this.state4 = new DHashStateVertexImpl(4, "STATE_FOUR", "<table><div>state4</div></table>", "004");
        this.state5 = new DHashStateVertexImpl(5, "STATE_FIVE", "<table><div>state5</div></table>", "005");
        this.graph = new InMemoryStateFlowGraph(new ExitNotifier(0), (StateVertexFactory)new DHashStateVertexFactory());
        this.graph.putIndex(this.index);
    }

    @Test
    public void testDuplicationAdding() {
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.index), (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state2), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state3), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state4), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)this.graph.putIfAbsent(this.state5), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        StateVertex stateReturned = this.graph.putIfAbsent((StateVertex)new DHashStateVertexImpl(12, "STATE_12", "<table><div><span>state22</span></div></table>", "002"));
        MatcherAssert.assertThat((Object)stateReturned, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        MatcherAssert.assertThat((Object)((DHashStateVertexImpl)stateReturned).getDHashVisual(), (Matcher)Is.is((Object)"002"));
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state2, this.newXpathEventable("/body/div[4]")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state2, this.index, this.newXpathEventable("/body/div[89]")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state2, this.state3, this.newXpathEventable("/home/a")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state4, this.newXpathEventable("/body/div[2]/div")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state2, this.state5, this.newXpathEventable("/body/div[5]")));
        Assert.assertFalse((boolean)this.graph.addEdge(this.state2, this.state5, this.newXpathEventable("/body/div[5]")));
        ImmutableSet clickables = this.graph.getOutgoingClickables(this.state2);
        Assert.assertEquals((long)3L, (long)clickables.size());
        clickables = this.graph.getIncomingClickable(this.state2);
        Assert.assertTrue((clickables.size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.graph.toString());
        Assert.assertEquals((long)this.state2.hashCode(), (long)this.state2.hashCode());
        Assert.assertTrue((boolean)this.state2.equals(new DHashStateVertexImpl(2, "STATE_2", "<table><div>state2</div></table>", "002")));
        Assert.assertTrue((boolean)this.graph.canGoTo(this.state2, this.state3));
        Assert.assertTrue((boolean)this.graph.canGoTo(this.state2, this.state5));
        Assert.assertFalse((boolean)this.graph.canGoTo(this.state2, this.state4));
        Assert.assertTrue((boolean)this.graph.canGoTo(this.state2, this.index));
        ImmutableList list = this.graph.getShortestPath(this.index, this.state3);
        Assert.assertEquals((long)list.size(), (long)2L);
        Eventable c = (Eventable)list.get(0);
        Assert.assertEquals((Object)c.getIdentification().getValue(), (Object)"/body/div[4]");
        c = (Eventable)list.get(1);
        Assert.assertEquals((Object)c.getIdentification().getValue(), (Object)"/home/a");
        DHashStateVertexImpl hold = new DHashStateVertexImpl(0, this.index.getName(), this.index.getDom(), "001");
        list = this.graph.getShortestPath((StateVertex)hold, this.state3);
        Assert.assertEquals((long)list.size(), (long)2L);
        ImmutableSet states = this.graph.getOutgoingStates(this.index);
        Assert.assertTrue((states.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)states.contains(this.state2));
        Assert.assertTrue((boolean)states.contains(this.state4));
        Assert.assertFalse((boolean)states.contains(this.state3));
        ImmutableSet allStates = this.graph.getAllStates();
        Assert.assertTrue((allStates.size() == 5 ? 1 : 0) != 0);
    }

    private Eventable newXpathEventable(String xPath) {
        return new Eventable(new Identification(Identification.How.xpath, xPath), Eventable.EventType.click);
    }

    @Test
    public void testCloneStates() {
        DHashStateVertexImpl state3clone2 = new DHashStateVertexImpl(3, "STATE_THREE", "<table><div>state2</div></table>", "002");
        Assert.assertTrue((this.graph.putIfAbsent(this.state2) == null ? 1 : 0) != 0);
        Assert.assertTrue((this.graph.putIfAbsent(this.state4) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.graph.addEdge(this.index, this.state2, this.newXpathEventable("/body/div[4]")));
        Assert.assertTrue((boolean)this.graph.addEdge(this.state4, (StateVertex)state3clone2, new Eventable(new Identification(Identification.How.xpath, "/home/a"), Eventable.EventType.click)));
        System.out.println(this.graph.toString());
    }
}

