/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.stateabstractions.visual;

import com.crawljax.stateabstractions.visual.OpenCVLoad;
import com.crawljax.stateabstractions.visual.imagehashes.DHash;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class VisualDHashTest {
    static final DHash DHASH = new DHash();

    @Test
    public void testDHash() throws IOException {
        String file = VisualDHashTest.class.getResource("/screenshots/bookobject.jpg").getPath();
        String hash = DHASH.getDHash(ImageIO.read(new File(file)));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.is((Object)"1011011111111110110111101100111011011110010111100101110100011101"));
        file = VisualDHashTest.class.getResource("/screenshots/bookscene.jpg").getPath();
        hash = DHASH.getDHash(ImageIO.read(new File(file)));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.is((Object)"0010101111000100110011100100110101010011000100011010000101010011"));
        file = VisualDHashTest.class.getResource("/screenshots/oracle.png").getPath();
        hash = DHASH.getDHash(ImageIO.read(new File(file)));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.is((Object)"1110000000000000000100001101000010010000000100000000000000010001"));
        file = VisualDHashTest.class.getResource("/screenshots/test.png").getPath();
        hash = DHASH.getDHash(ImageIO.read(new File(file)));
        MatcherAssert.assertThat((Object)hash, (Matcher)Matchers.is((Object)"1110000000000000000100001101100010010000000100000000000000010001"));
    }

    @Test
    public void testDHashIdenticalImages() throws IOException {
        String file = VisualDHashTest.class.getResource("/screenshots/bookobject.jpg").getPath();
        String file2 = VisualDHashTest.class.getResource("/screenshots/bookobject.jpg").getPath();
        Assert.assertTrue((boolean)DHASH.imagesPerceptuallySimilar(ImageIO.read(new File(file)), ImageIO.read(new File(file2))));
        file = VisualDHashTest.class.getResource("/screenshots/bookscene.jpg").getPath();
        file2 = VisualDHashTest.class.getResource("/screenshots/bookscene.jpg").getPath();
        Assert.assertTrue((boolean)DHASH.imagesPerceptuallySimilar(file, file2));
        file = VisualDHashTest.class.getResource("/screenshots/oracle.png").getPath();
        file2 = VisualDHashTest.class.getResource("/screenshots/oracle.png").getPath();
        Assert.assertTrue((boolean)DHASH.imagesPerceptuallySimilar(file, file2));
        file = VisualDHashTest.class.getResource("/screenshots/test.png").getPath();
        file2 = VisualDHashTest.class.getResource("/screenshots/test.png").getPath();
        Assert.assertTrue((boolean)DHASH.imagesPerceptuallySimilar(file, file2));
    }

    @Test
    public void testDHashSimilarImages() throws IOException {
        String file = VisualDHashTest.class.getResource("/screenshots/oracle.png").getPath();
        String file2 = VisualDHashTest.class.getResource("/screenshots/test.png").getPath();
        Assert.assertTrue((boolean)DHASH.imagesPerceptuallySimilar(ImageIO.read(new File(file)), ImageIO.read(new File(file2))));
    }

    @Test
    public void testDHashDifferentImages() throws IOException {
        String file = VisualDHashTest.class.getResource("/screenshots/bookscene.jpg").getPath();
        String file2 = VisualDHashTest.class.getResource("/screenshots/bookobject.jpg").getPath();
        Assert.assertFalse((boolean)DHASH.imagesPerceptuallySimilar(ImageIO.read(new File(file)), ImageIO.read(new File(file2))));
    }

    static {
        OpenCVLoad.load();
    }
}

