/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.test;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.state.PostCrawlStateGraphChecker;
import com.crawljax.test.WebServer;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCrawler {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCrawler.class);
    private final WebServer webServer;
    private final AtomicBoolean hasSetup = new AtomicBoolean(false);
    private CrawljaxConfiguration.CrawljaxConfigurationBuilder configBuilder;
    private String siteExtension;

    public BaseCrawler(String siteExtension) {
        this.siteExtension = siteExtension;
        URL sampleSites = BaseCrawler.class.getResource("/site");
        LOG.debug("Loading web server with from folder {}", (Object)sampleSites.toExternalForm());
        this.webServer = new WebServer(Resource.newResource((URL)sampleSites));
    }

    public BaseCrawler(Resource webFolder, String siteExtension) {
        this.siteExtension = Strings.nullToEmpty((String)siteExtension);
        try {
            LOG.debug("Loading web server with from folder {}", (Object)webFolder.getURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.webServer = new WebServer(webFolder);
    }

    public BaseCrawler(Resource webFolder) {
        this(webFolder, "");
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setup() {
        try {
            this.webServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start the server", e);
        }
        this.configBuilder = this.newCrawlConfigurationBuilder();
        this.hasSetup.set(true);
    }

    protected CrawljaxConfiguration.CrawljaxConfigurationBuilder newCrawlConfigurationBuilder() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((URI)this.getUrl());
        builder.setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
        builder.crawlRules().clickDefaultElements();
        builder.setUnlimitedRuntime();
        builder.setUnlimitedCrawlDepth();
        builder.addPlugin(new Plugin[]{new PostCrawlStateGraphChecker()});
        return builder;
    }

    protected URI getUrl() {
        return this.webServer.getSiteUrl().resolve(this.siteExtension);
    }

    public CrawljaxConfiguration getConfig() {
        return this.configBuilder.build();
    }

    public CrawlSession crawl() throws CrawljaxException {
        if (!this.hasSetup.get()) {
            this.setup();
        }
        CrawljaxRunner crawljax = new CrawljaxRunner(this.configBuilder.build());
        CrawlSession session = crawljax.call();
        this.webServer.stop();
        return session;
    }

    public CrawlSession crawlWith(Plugin ... plugins) {
        if (!this.hasSetup.get()) {
            this.setup();
        }
        for (Plugin plugin : plugins) {
            this.configBuilder.addPlugin(new Plugin[]{plugin});
        }
        return this.crawl();
    }

    public void showWebSite() throws Exception {
        this.webServer.start();
        System.out.println(this.getUrl());
        this.webServer.join();
    }
}

