/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.test;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.junit.rules.ExternalResource;

public class RunWithWebServer
extends ExternalResource {
    private final Resource resource;
    private int port;
    private URI demoSite;
    private Server server;
    private boolean started;

    public RunWithWebServer(String classPathResource) {
        this.resource = Resource.newClassPathResource((String)classPathResource);
    }

    public void before() throws Exception {
        this.server = this.newWebServer();
        this.server.start();
        this.port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        this.demoSite = URI.create("http://localhost:" + this.port + "/");
        this.started = true;
    }

    protected Server newWebServer() {
        Server server = new Server(0);
        ResourceHandler handler = new ResourceHandler();
        handler.setBaseResource(this.resource);
        server.setHandler((Handler)handler);
        return server;
    }

    public void after() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop the server", e);
        }
    }

    public URI getSiteUrl() {
        this.checkServerStarted();
        return this.demoSite;
    }

    public int getPort() {
        this.checkServerStarted();
        return this.port;
    }

    public CrawljaxConfiguration.CrawljaxConfigurationBuilder newConfigBuilder() {
        return CrawljaxConfiguration.builderFor((URI)this.getSiteUrl()).setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
    }

    public CrawljaxConfiguration.CrawljaxConfigurationBuilder newConfigBuilder(String context) {
        return CrawljaxConfiguration.builderFor((String)(this.getSiteUrl() + context)).setBrowserConfig(new BrowserConfiguration(BrowserProvider.getBrowserType()));
    }

    public void stop() throws Exception {
        this.checkServerStarted();
        this.server.stop();
    }

    private void checkServerStarted() {
        Preconditions.checkState((boolean)this.started, (Object)"Server not started");
    }
}

