/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.test;

import com.crawljax.browser.matchers.StateFlowGraphMatchers;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.forms.FormInputValueHelper;
import com.crawljax.test.BaseCrawler;
import com.crawljax.test.BrowserTest;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={BrowserTest.class})
public abstract class SimpleCrawlTest {
    private final int NUMBER_OF_STATES;
    private final int NUMBER_OF_EDGES;
    private CrawlSession crawl;

    public SimpleCrawlTest(int numberOfStates, int numberOfEdges) {
        this.NUMBER_OF_STATES = numberOfStates;
        this.NUMBER_OF_EDGES = numberOfEdges;
    }

    @Before
    public void setup() {
        FormInputValueHelper.reset();
    }

    @Test
    public void testInputCrawlerFlowGraph() throws Exception {
        BaseCrawler crawler = this.getCrawler();
        this.crawl = crawler.crawl();
        this.verifyGraphSize(this.NUMBER_OF_STATES, this.NUMBER_OF_EDGES);
    }

    public abstract BaseCrawler getCrawler();

    protected void verifyGraphSize(int numberOfStates, int numberOfEdges) {
        StateFlowGraph stateFlowGraph = this.crawl.getStateFlowGraph();
        MatcherAssert.assertThat((Object)stateFlowGraph, StateFlowGraphMatchers.hasStates(numberOfStates));
        MatcherAssert.assertThat((Object)stateFlowGraph, StateFlowGraphMatchers.hasEdges(numberOfEdges));
    }
}

