/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.test;

import com.google.common.base.Preconditions;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.netpreserve.jwarc.net.WarcServer;

public class WarchiveServer
implements Runnable {
    private final String resource;
    private int port;
    ServerSocket socket;
    private URI demoSite;
    private WarcServer server;
    private boolean started;

    public WarchiveServer(String directory, int port) {
        this.resource = directory;
        this.port = port;
    }

    public void start() throws Exception {
        List warcs = Files.list(Paths.get(this.resource, new String[0])).collect(Collectors.toList());
        this.socket = new ServerSocket(this.port);
        this.server = new WarcServer(this.socket, warcs);
        System.err.println("Listening on port " + this.port);
        this.started = true;
        this.demoSite = URI.create("http://localhost:" + this.port + "/");
        this.server.listen();
    }

    public URI getSiteUrl() {
        this.checkServerStarted();
        return this.demoSite;
    }

    public int getPort() {
        this.checkServerStarted();
        return this.port;
    }

    public synchronized void stop() {
        this.checkServerStarted();
        try {
            this.socket.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop the server", e);
        }
    }

    private void checkServerStarted() {
        Preconditions.checkState((boolean)this.started, (Object)"Server not started");
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

