/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.test;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;

public class WebServer {
    private final Resource resource;
    private int port;
    private URI demoSite;
    private Server server;
    private boolean started;

    public WebServer(Resource classPathResource) {
        this.resource = classPathResource;
    }

    public void start() throws Exception {
        this.server = new Server(0);
        ResourceHandler handler = new ResourceHandler();
        handler.setBaseResource(this.resource);
        this.server.setHandler((Handler)handler);
        this.server.start();
        this.port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        this.demoSite = URI.create("http://localhost:" + this.port + "/");
        this.started = true;
    }

    public URI getSiteUrl() {
        this.checkServerStarted();
        return this.demoSite;
    }

    public int getPort() {
        this.checkServerStarted();
        return this.port;
    }

    public void stop() {
        this.checkServerStarted();
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop the server", e);
        }
    }

    private void checkServerStarted() {
        Preconditions.checkState((boolean)this.started, (Object)"Server not started");
    }

    public void join() throws InterruptedException {
        this.server.join();
    }
}

