/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.test.rules;

import com.google.common.base.Preconditions;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.junit.rules.ExternalResource;

public class TempDirInTargetFolder
extends ExternalResource {
    private static final String DATE_FORMAT = "yyyy-MM-dd-HH.mm.ss";
    private final File target;
    private final String prefix;
    private final boolean override;
    private File tmpDir;

    public TempDirInTargetFolder(String prefix, boolean override) {
        this.prefix = prefix;
        this.override = override;
        this.target = new File("target/test-data");
        if (!this.target.exists()) {
            boolean created = this.target.mkdirs();
            Preconditions.checkArgument((boolean)created, (Object)"Could not create target/test-data dir");
        }
    }

    protected void before() {
        if (this.override) {
            this.tmpDir = new File(this.target, this.prefix);
            if (this.tmpDir.exists()) {
                FileUtils.deleteQuietly((File)this.tmpDir);
            }
        } else {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String suffix = format.format(new Date());
            this.tmpDir = new File(this.target, this.prefix + "-" + suffix);
        }
        boolean created = this.tmpDir.mkdirs();
        Preconditions.checkArgument((boolean)created, (Object)"Could not create tmpDir");
    }

    public File getTempDir() {
        return this.tmpDir;
    }
}

