/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.util.DOMComparer;
import com.crawljax.util.DomUtils;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class DOMComparerTest {
    @Test
    public void compareNoDifference() throws IOException {
        String html = "<html><body><p>No difference</p></body></html>";
        Document control = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)control);
        Document test = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)test);
        DOMComparer dc = new DOMComparer(control, test);
        List differences = dc.compare();
        MatcherAssert.assertThat((Object)differences, (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
    }

    @Test
    public void comparePartialDifference() throws IOException {
        String controlHTML = "<html><body><header>Crawljax</header><p>There are differences</p></body></html>";
        String testHTML = "<html><head><title>Crawljax</title></head><body><p>There are differences.</body></html>";
        int EXPECTED_DIFF = 7;
        Document control = DomUtils.asDocument((String)controlHTML);
        Assert.assertNotNull((Object)control);
        Document test = DomUtils.asDocument((String)testHTML);
        Assert.assertNotNull((Object)test);
        DOMComparer dc = new DOMComparer(control, test);
        List differences = dc.compare();
        Assert.assertEquals((String)"Error: Did not find 5 differences", (long)differences.size(), (long)7L);
    }
}

