/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.util.DomUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomUtilsTest {
    @Test
    public void testGetElementString() throws IOException, SAXException {
        Document dom = DomUtils.getDocumentNoBalance((String)"<html><body><div class=\"bla\" id=\"test\">Test Str</div></body></html>");
        Assert.assertEquals((Object)"\"Test Str\" ID: test class=bla id=test", (Object)DomUtils.getElementString((Element)dom.getElementById("test")).trim());
    }

    @Test
    public void testGetElementByXpath() throws XPathExpressionException, IOException {
        String html = "<body><div id='firstdiv'></div><div><span id='thespan'><a id='thea'>test</a></span></div></body>";
        String xpath = "/HTML[1]/BODY[1]/DIV[1]";
        Document dom = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)dom);
        Element elem = DomUtils.getElementByXpath((Document)dom, (String)xpath);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((Object)"ID: firstdiv id=firstdiv", (Object)DomUtils.getElementString((Element)elem).trim());
        xpath = "/HTML[1]/BODY[1]/DIV[2]/SPAN[1]";
        elem = DomUtils.getElementByXpath((Document)dom, (String)xpath);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((Object)"\"test\" ID: thespan id=thespan", (Object)DomUtils.getElementString((Element)elem).trim());
        xpath = "/HTML[1]/BODY[1]/DIV[2]/SPAN[1]/A[1]";
        elem = DomUtils.getElementByXpath((Document)dom, (String)xpath);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((Object)"\"test\" ID: thea id=thea", (Object)DomUtils.getElementString((Element)elem).trim());
    }

    @Test
    public void testRemoveTags() throws IOException {
        String html = "<body><div id='testdiv'</div><div style=\"colour:#FF0000\"><h>Header</h></div></body>";
        Document dom = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)dom);
        Assert.assertTrue((dom.getElementsByTagName("div").getLength() != 0 ? 1 : 0) != 0);
        DomUtils.removeTags((Document)dom, (String)"div");
        Assert.assertTrue((dom.getElementsByTagName("div").getLength() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveScriptTags() throws IOException {
        String html = "<body><script type=\"test/javascript\">document.write(\"Testing!\")</script></body>";
        Document dom = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)dom);
        Assert.assertTrue((dom.getElementsByTagName("script").getLength() != 0 ? 1 : 0) != 0);
        DomUtils.removeScriptTags((Document)dom);
        Assert.assertTrue((dom.getElementsByTagName("script").getLength() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetDocumentToString() throws IOException {
        String html = "<body><div id='testdiv'</div><div style=\"colour:#FF0000\"><h>Header</h></div></body>";
        String expectedDocString = "<HTML><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></HEAD><BODY><DIV id=\"testdiv\"></DIV><DIV style=\"colour:#FF0000\"><H>Header</H></DIV></BODY></HTML>";
        Document dom = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)dom);
        Assert.assertEquals((Object)expectedDocString, (Object)DomUtils.getDocumentToString((Document)dom).replace("\n", "").replace("\r", ""));
    }

    @Test
    public void testGetTextValue() throws IOException {
        String expectedText1 = "Testing title text";
        String expectedText2 = "Testing content test";
        String expectedText3 = "Testing alternative text";
        String html = "<body><br id='test1' title=\"" + expectedText1 + "\"><p id='test2'>" + expectedText2 + "</p><br id='test3' alt=\"" + expectedText3 + "\"></body>";
        Document dom = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)dom);
        Assert.assertEquals((Object)expectedText1, (Object)DomUtils.getTextValue((Element)dom.getElementById("test1")));
        Assert.assertEquals((Object)expectedText2, (Object)DomUtils.getTextValue((Element)dom.getElementById("test2")));
        Assert.assertEquals((Object)expectedText3, (Object)DomUtils.getTextValue((Element)dom.getElementById("test3")));
    }

    @Test
    public void testRemoveNewLines() {
        String html = "<HTML>\n<HEAD>\n<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></HEAD>\n<BODY>\n<DIV id=\"testdiv\"></DIV><DIV style=\"colour:#FF0000\">\n<H>Header</H>\n</DIV>\n</BODY>\n</HTML>";
        String expectedString = "<HTML><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></HEAD><BODY><DIV id=\"testdiv\"></DIV><DIV style=\"colour:#FF0000\"><H>Header</H></DIV></BODY></HTML>";
        Assert.assertEquals((Object)expectedString, (Object)DomUtils.removeNewLines((String)html));
    }

    @Test
    public void testReplaceString() {
        String regex = "hello|world";
        String toReplace = "hello world helloworld worldhello";
        String expectedString = "testing testing testingtesting testingtesting";
        Assert.assertEquals((Object)expectedString, (Object)DomUtils.replaceString((String)toReplace, (String)regex, (String)"testing"));
    }

    @Test
    public void testAddFolderSlashIfNeeded() {
        String incompleteFolderName = "path/testpath";
        String expectedPath = incompleteFolderName + "/";
        Assert.assertEquals((Object)expectedPath, (Object)DomUtils.addFolderSlashIfNeeded((String)incompleteFolderName));
    }

    @Test
    public void getElementAttributes() throws SAXException, IOException {
        Document dom = DomUtils.getDocumentNoBalance((String)"<html><body><div class=\"bla\" id=\"test\">Bla</div></body></html>");
        Assert.assertEquals((Object)"class=bla id=test", (Object)DomUtils.getAllElementAttributes((Element)dom.getElementById("test")));
    }

    @Test
    public void writeAndGetContents() throws IOException, TransformerException {
        File f = File.createTempFile("HelperTest.writeAndGetContents", ".tmp");
        f.deleteOnExit();
        DomUtils.writeDocumentToFile((Document)DomUtils.asDocument((String)"<html><body><p>Test</p></body></html>"), (String)f.getAbsolutePath(), (String)"html", (int)2);
        Assert.assertNotSame((Object)"", (Object)DomUtils.getTemplateAsString((String)f.getAbsolutePath()));
        Assert.assertTrue((boolean)f.exists());
    }

    @Test
    public void testGetDocument() throws IOException {
        String html = "<html><body><p/></body></html>";
        Document doc = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)doc);
    }

    @Test
    public void whenGetDocumentToStringNoCharEscape() throws IOException {
        String html = "<html><body><p>bla</p></body></html>";
        Document doc = DomUtils.asDocument((String)html);
        MatcherAssert.assertThat((Object)DomUtils.getDocumentToString((Document)doc).contains("<P>"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testLeafNodeSize() throws IOException {
        String html = "<html><body><p>bla</p></body></html>";
        Document doc = DomUtils.asDocument((String)html);
        try {
            MatcherAssert.assertThat((Object)DomUtils.getAllLeafNodes((Document)doc).getLength(), (Matcher)Is.is((Object)2));
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLeafNodeSize2() throws IOException {
        String html = "<html><body><p>bla</p></body></html>";
        Document doc = DomUtils.asDocument((String)html);
        try {
            MatcherAssert.assertThat((Object)DomUtils.getNumLeafNodes((Node)doc.getElementsByTagName("body").item(0)), (Matcher)Is.is((Object)1));
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetText() throws IOException {
        String html = "<HTML lang=\\\"en\\\"><!--\nPetClinic :: a Spring Framework demonstration\n--><HEAD><META http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\">\n    <META content=\\\"text/html; charset=UTF-8\\\" http-equiv=\\\"Content-Type\\\">\n    <TITLE>PetClinic :: a Spring Framework demonstration</TITLE>\n\n\n    \n    <LINK href=\\\"/petclinic/webjars/bootstrap/2.3.0/css/bootstrap.min.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n\n    \n    <LINK href=\\\"/petclinic/resources/css/petclinic.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n\n    \n    \n\n\t<!-- jquery-ui.js file is really big so we only load what we need instead of loading everything -->\n    \n    \n\n\t\n    \n    \n    <!-- jquery-ui.css file is not that big so we can afford to load it -->\n    \n    <LINK href=\\\"/petclinic/webjars/jquery-ui/1.10.3/themes/base/jquery-ui.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n</HEAD><BODY style=\\\"\\\">\n<DIV class=\\\"container\\\">\n    \n\n\n\n<IMG src=\\\"/petclinic/resources/images/banner-graphic.png;jsessionid=278F291142D939304645517B5C814EC6\\\">\n\n<DIV class=\\\"navbar\\\" style=\\\"width: 601px;\\\">\n    <DIV class=\\\"navbar-inner\\\">\n        <UL class=\\\"nav\\\">\n            <LI style=\\\"width: 120px;\\\"><A href=\\\"/petclinic/;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-home\\\"></I>\n                Home</A></LI>\n            <LI style=\\\"width: 150px;\\\"><A href=\\\"/petclinic/owners/find.html;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-search\\\"></I> Find owners</A></LI>\n            <LI style=\\\"width: 160px;\\\"><A href=\\\"/petclinic/vets.html;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-th-list\\\"></I> Veterinarians</A></LI>\n            <LI style=\\\"width: 110px;\\\"><A href=\\\"/petclinic/oups.html;jsessionid=278F291142D939304645517B5C814EC6\\\" title=\\\"trigger a RuntimeException to see how it is handled\\\"><I class=\\\"icon-warning-sign\\\"></I> Error</A></LI>\n        </UL>\n    </DIV>\n</DIV>\n\t\n\n    <H2>Welcome</H2>\n    \n    <IMG src=\\\"/petclinic/resources/images/pets.png;jsessionid=278F291142D939304645517B5C814EC6\\\">\n\n    \n\n<TABLE class=\\\"footer\\\">\n    <TBODY><TR>\n        <TD width=\\\"70%\\\"></TD>\n        <TD align=\\\"right\\\"><IMG alt=\\\"Sponsored by Pivotal\\\" src=\\\"/petclinic/resources/images/spring-pivotal-logo.png;jsessionid=278F291142D939304645517B5C814EC6\\\"></TD>\n    </TR>\n</TBODY></TABLE>\n\n\n\n\n</DIV>\n\n\n\n</BODY></HTML>";
        Document doc = DomUtils.asDocument((String)html);
        try {
            String content = DomUtils.getTextContent((Document)doc, (boolean)true);
            MatcherAssert.assertThat((Object)content.contains("a Spring Framework"), (Matcher)Is.is((Object)true));
            content = DomUtils.getTextContent((Document)doc, (boolean)false);
            MatcherAssert.assertThat((Object)content.contains("a Spring Framework"), (Matcher)Is.is((Object)false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetDOMContent() throws IOException {
        String html = "<HTML lang=\\\"en\\\"><!--\nPetClinic :: a Spring Framework demonstration\n--><HEAD><META http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\">\n    <META content=\\\"text/html; charset=UTF-8\\\" http-equiv=\\\"Content-Type\\\">\n    <TITLE>PetClinic :: a Spring Framework demonstration</TITLE>\n\n\n    \n    <LINK href=\\\"/petclinic/webjars/bootstrap/2.3.0/css/bootstrap.min.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n\n    \n    <LINK href=\\\"/petclinic/resources/css/petclinic.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n\n    \n    \n\n\t<!-- jquery-ui.js file is really big so we only load what we need instead of loading everything -->\n    \n    \n\n\t\n    \n    \n    <!-- jquery-ui.css file is not that big so we can afford to load it -->\n    \n    <LINK href=\\\"/petclinic/webjars/jquery-ui/1.10.3/themes/base/jquery-ui.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n</HEAD><BODY style=\\\"\\\">\n<DIV class=\\\"container\\\">\n    \n\n\n\n<IMG src=\\\"/petclinic/resources/images/banner-graphic.png;jsessionid=278F291142D939304645517B5C814EC6\\\">\n\n<DIV class=\\\"navbar\\\" style=\\\"width: 601px;\\\">\n    <DIV class=\\\"navbar-inner\\\">\n        <UL class=\\\"nav\\\">\n            <LI style=\\\"width: 120px;\\\"><A href=\\\"/petclinic/;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-home\\\"></I>\n                Home</A></LI>\n            <LI style=\\\"width: 150px;\\\"><A href=\\\"/petclinic/owners/find.html;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-search\\\"></I> Find owners</A></LI>\n            <LI style=\\\"width: 160px;\\\"><A href=\\\"/petclinic/vets.html;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-th-list\\\"></I> Veterinarians</A></LI>\n            <LI style=\\\"width: 110px;\\\"><A href=\\\"/petclinic/oups.html;jsessionid=278F291142D939304645517B5C814EC6\\\" title=\\\"trigger a RuntimeException to see how it is handled\\\"><I class=\\\"icon-warning-sign\\\"></I> Error</A></LI>\n        </UL>\n    </DIV>\n</DIV>\n\t\n\n    <H2>Welcome</H2>\n    \n    <IMG src=\\\"/petclinic/resources/images/pets.png;jsessionid=278F291142D939304645517B5C814EC6\\\">\n\n    \n\n<TABLE class=\\\"footer\\\">\n    <TBODY><TR>\n        <TD width=\\\"70%\\\"></TD>\n        <TD align=\\\"right\\\"><IMG alt=\\\"Sponsored by Pivotal\\\" src=\\\"/petclinic/resources/images/spring-pivotal-logo.png;jsessionid=278F291142D939304645517B5C814EC6\\\"></TD>\n    </TR>\n</TBODY></TABLE>\n\n\n\n\n</DIV>\n\n\n\n</BODY></HTML>";
        Document doc = DomUtils.asDocument((String)html);
        try {
            String content = DomUtils.getDOMContent((Document)doc);
            MatcherAssert.assertThat((Object)content.contains("Veterinarians"), (Matcher)Is.is((Object)true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetDOMwithoutText() throws IOException {
        String html = "<HTML lang=\\\"en\\\"><!--\nPetClinic :: a Spring Framework demonstration\n--><HEAD><META http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\">\n    <META content=\\\"text/html; charset=UTF-8\\\" http-equiv=\\\"Content-Type\\\">\n    <TITLE>PetClinic :: a Spring Framework demonstration</TITLE>\n\n\n    \n    <LINK href=\\\"/petclinic/webjars/bootstrap/2.3.0/css/bootstrap.min.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n\n    \n    <LINK href=\\\"/petclinic/resources/css/petclinic.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n\n    \n    \n\n\t<!-- jquery-ui.js file is really big so we only load what we need instead of loading everything -->\n    \n    \n\n\t\n    \n    \n    <!-- jquery-ui.css file is not that big so we can afford to load it -->\n    \n    <LINK href=\\\"/petclinic/webjars/jquery-ui/1.10.3/themes/base/jquery-ui.css;jsessionid=278F291142D939304645517B5C814EC6\\\" rel=\\\"stylesheet\\\">\n</HEAD><BODY style=\\\"\\\">\n<DIV class=\\\"container\\\">\n    \n\n\n\n<IMG src=\\\"/petclinic/resources/images/banner-graphic.png;jsessionid=278F291142D939304645517B5C814EC6\\\">\n\n<DIV class=\\\"navbar\\\" style=\\\"width: 601px;\\\">\n    <DIV class=\\\"navbar-inner\\\">\n        <UL class=\\\"nav\\\">\n            <LI style=\\\"width: 120px;\\\"><A href=\\\"/petclinic/;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-home\\\"></I>\n                Home</A></LI>\n            <LI style=\\\"width: 150px;\\\"><A href=\\\"/petclinic/owners/find.html;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-search\\\"></I> Find owners</A></LI>\n            <LI style=\\\"width: 160px;\\\"><A href=\\\"/petclinic/vets.html;jsessionid=278F291142D939304645517B5C814EC6\\\"><I class=\\\"icon-th-list\\\"></I> Veterinarians</A></LI>\n            <LI style=\\\"width: 110px;\\\"><A href=\\\"/petclinic/oups.html;jsessionid=278F291142D939304645517B5C814EC6\\\" title=\\\"trigger a RuntimeException to see how it is handled\\\"><I class=\\\"icon-warning-sign\\\"></I> Error</A></LI>\n        </UL>\n    </DIV>\n</DIV>\n\t\n\n    <H2>Welcome</H2>\n    \n    <IMG src=\\\"/petclinic/resources/images/pets.png;jsessionid=278F291142D939304645517B5C814EC6\\\">\n\n    \n\n<TABLE class=\\\"footer\\\">\n    <TBODY><TR>\n        <TD width=\\\"70%\\\"></TD>\n        <TD align=\\\"right\\\"><IMG alt=\\\"Sponsored by Pivotal\\\" src=\\\"/petclinic/resources/images/spring-pivotal-logo.png;jsessionid=278F291142D939304645517B5C814EC6\\\"></TD>\n    </TR>\n</TBODY></TABLE>\n\n\n\n\n</DIV>\n\n\n\n</BODY></HTML>";
        Document doc = DomUtils.asDocument((String)html);
        try {
            String content = DomUtils.getDOMWithoutContent((Document)doc);
            MatcherAssert.assertThat((Object)content.contains("Veterinarians"), (Matcher)Is.is((Object)false));
            doc = DomUtils.asDocument((String)content);
            String textContent = DomUtils.getTextContent((Document)doc, (boolean)false);
            MatcherAssert.assertThat((Object)textContent.isEmpty(), (Matcher)Is.is((Object)true));
            textContent = DomUtils.getTextContent((Document)doc, (boolean)true);
            MatcherAssert.assertThat((Object)textContent.isEmpty(), (Matcher)Is.is((Object)true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void getAllSubtreeNodesTest() throws IOException, XPathExpressionException {
        String html = "<body><div id='firstdiv'></div><div><span id='thespan'><a id='thea'>test</a></span></div></body>";
        String xpath = "/HTML[1]/BODY[1]";
        Document dom = DomUtils.asDocument((String)html);
        Element parent = DomUtils.getElementByXpath((Document)dom, (String)xpath);
        NodeList childNodes = DomUtils.getAllSubtreeNodes((Node)parent);
        System.out.println(childNodes.getLength());
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            System.out.println(childNode.getNodeName());
        }
        Assert.assertTrue((childNodes.getLength() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void getAllAttributesTest() throws IOException, XPathExpressionException {
        String html = "<body><div id='firstdiv'></div><div><span id='thespan' xyz='xyz'><a href='#' id='thea'>test</a></span></div></body>";
        Document dom = DomUtils.asDocument((String)html);
        HashMap attributeMap = new HashMap();
        DomUtils.getAllAttributes((Document)dom, attributeMap, null);
        System.out.println(attributeMap);
        String[] array = new String[]{"firstdiv", "thespan", "thea"};
        List<String> expecteds = Arrays.asList(array);
        String[] actuals = ((Set)attributeMap.get("id")).toArray(new String[0]);
        Assert.assertTrue((String)"Wrong return attributes", (boolean)((Set)attributeMap.get("id")).containsAll(expecteds));
    }
}

