/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.util.UrlUtils;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class UrlUtilsTest {
    @Test
    public void getVarFromQueryString() {
        MatcherAssert.assertThat((Object)UrlUtils.getVarFromQueryString((String)"page", (String)"?sub=1&userid=123&page=home&goto=0"), (Matcher)Is.is((Object)"home"));
        MatcherAssert.assertThat((Object)UrlUtils.getVarFromQueryString(null, (String)"?sub=1&userid=123&page=home&goto=0"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)UrlUtils.getVarFromQueryString((String)"page", (String)""), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)UrlUtils.getVarFromQueryString((String)"page", (String)"?sub=1&userid=123&NotPage=home&goto=0"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)UrlUtils.getVarFromQueryString((String)"page", (String)"?sub=1&userid=123&page=home=moreStringInfo&goto=0"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void getBaseUrl() {
        Assert.assertEquals((Object)"http://crawljax.com", (Object)UrlUtils.getBaseUrl((String)"http://crawljax.com/about/"));
        Assert.assertEquals((Object)"https://crawljax.com", (Object)UrlUtils.getBaseUrl((String)"https://crawljax.com/about/"));
        Assert.assertEquals((Object)"http://crawljax.com", (Object)UrlUtils.getBaseUrl((String)"http://crawljax.com/about/history/"));
        Assert.assertEquals((Object)"http://crawljax.com", (Object)UrlUtils.getBaseUrl((String)"http://crawljax.com/"));
        Assert.assertEquals((Object)"http://crawljax.com", (Object)UrlUtils.getBaseUrl((String)"http://crawljax.com"));
        Assert.assertEquals((Object)"http://crawls.crawljax.com", (Object)UrlUtils.getBaseUrl((String)"http://crawls.crawljax.com/demo"));
        Assert.assertEquals((Object)"http://crawls.crawljax.com", (Object)UrlUtils.getBaseUrl((String)"http://crawls.crawljax.com"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenUrlIsJavaScriptItDoesNotExtract() {
        UrlUtils.extractNewUrl((String)"http://example.com", (String)"javascript:void(0)");
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenUrlisMailItDoesNotExtract() {
        UrlUtils.extractNewUrl((String)"http://example.com", (String)"mailto:test@example.com");
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenUrlAboutBlankDoesNotExtract() {
        UrlUtils.extractNewUrl((String)"http://example.com", (String)"about:blank");
    }

    @Test
    public void testExtractNewUrl() {
        String base = "http://example.com";
        URI baseWithA = URI.create("http://example.com/a");
        MatcherAssert.assertThat((Object)UrlUtils.extractNewUrl((String)"http://example.com", (String)"a"), (Matcher)Is.is((Object)baseWithA));
        MatcherAssert.assertThat((Object)UrlUtils.extractNewUrl((String)"http://example.com/example", (String)"/a"), (Matcher)Is.is((Object)baseWithA));
        MatcherAssert.assertThat((Object)UrlUtils.extractNewUrl((String)"http://example.com/example/b", (String)"/a"), (Matcher)Is.is((Object)baseWithA));
        MatcherAssert.assertThat((Object)UrlUtils.extractNewUrl((String)"http://example.com/example/b", (String)"a"), (Matcher)Is.is((Object)URI.create("http://example.com/example/a")));
        MatcherAssert.assertThat((Object)UrlUtils.extractNewUrl((String)"http://example.com/example/b", (String)"../a"), (Matcher)Is.is((Object)baseWithA));
        MatcherAssert.assertThat((Object)UrlUtils.extractNewUrl((String)"http://example.com", (String)"http://test.example.com"), (Matcher)Is.is((Object)URI.create("http://test.example.com")));
        MatcherAssert.assertThat((Object)UrlUtils.extractNewUrl((String)"http://example.com", (String)"#someHash"), (Matcher)Is.is((Object)URI.create("http://example.com/#someHash")));
    }

    @Test
    public void testIsSameDomain() {
        MatcherAssert.assertThat((Object)UrlUtils.isSameDomain((String)"http://example.com", (URI)URI.create("http://example.com")), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)UrlUtils.isSameDomain((String)"http://test.com", (URI)URI.create("http://example.com")), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)UrlUtils.isSameDomain((String)"http://test.example.com", (URI)URI.create("http://example.com")), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)UrlUtils.isSameDomain((String)"https://example.com", (URI)URI.create("http://example.com")), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)UrlUtils.isSameDomain((String)"https://example.com/#something=blah|somethingelse=blah1", (URI)URI.create("http://example.com")), (Matcher)Is.is((Object)true));
    }
}

