/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathHelperTest {
    @Test
    public void testGetXpathExpression() throws IOException {
        String html = "<body><div id='firstdiv'></div><div><span id='thespan'><a id='thea'>test</a></span></div></body>";
        Document dom = DomUtils.asDocument((String)html);
        Assert.assertNotNull((Object)dom);
        String expectedXpath = "//DIV[@id = 'firstdiv']";
        String xpathExpr = XPathHelper.getXPathExpression_other((Node)dom.getElementById("firstdiv"));
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
        expectedXpath = "//SPAN[@id = 'thespan']";
        xpathExpr = XPathHelper.getXPathExpression_other((Node)dom.getElementById("thespan"));
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
        expectedXpath = "//A[@id = 'thea']";
        xpathExpr = XPathHelper.getXPathExpression_other((Node)dom.getElementById("thea"));
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
        html = "<body><div id='firstdiv'><span><div></div></span></div><div><span id='thespan'><div></div></span><span></span></div></body>";
        dom = DomUtils.asDocument((String)html);
        expectedXpath = "//DIV[@id = 'firstdiv']/SPAN[1]/DIV[1]";
        xpathExpr = XPathHelper.getXPathExpression_other((Node)dom.getElementById("firstdiv").getFirstChild().getFirstChild());
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
        expectedXpath = "//SPAN[@id = 'thespan']/DIV[1]";
        xpathExpr = XPathHelper.getXPathExpression_other((Node)dom.getElementById("thespan").getFirstChild());
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
        expectedXpath = "/HTML[1]/BODY[1]/DIV[2]/SPAN[2]";
        xpathExpr = XPathHelper.getXPathExpression_other((Node)dom.getFirstChild().getLastChild().getLastChild().getLastChild());
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
        expectedXpath = "/HTML[1]/BODY[1]/DIV[2]/SPAN[2]";
        xpathExpr = XPathHelper.getSkeletonXpath((Node)dom.getFirstChild().getLastChild().getLastChild().getLastChild());
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
        expectedXpath = "SPAN[2]";
        xpathExpr = XPathHelper.getXPathFromSpecificParent((Node)dom.getFirstChild().getLastChild().getLastChild().getLastChild(), (Node)dom.getFirstChild().getLastChild().getLastChild());
        Assert.assertEquals((Object)expectedXpath, (Object)xpathExpr);
    }

    @Test
    public void whenWildcardsUsedXpathShouldFindTheElements() throws Exception {
        String html = "<body><DIV><P>Bla</P><P>Bla2</P></DIV><DIV id='exclude'><P>Ex</P><P>Ex2</P></DIV></body>";
        String xpathAllP = "//DIV//P";
        String xpathOnlyExcludedP = "//DIV[@id='exclude']//P";
        NodeList nodes = XPathHelper.evaluateXpathExpression((String)html, (String)xpathAllP);
        MatcherAssert.assertThat((Object)nodes.getLength(), (Matcher)Is.is((Object)4));
        nodes = XPathHelper.evaluateXpathExpression((String)html, (String)xpathOnlyExcludedP);
        MatcherAssert.assertThat((Object)nodes.getLength(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testXPathLocation() {
        String html = "<HTML><LINK foo=\"bar\">woei</HTML>";
        String xpath = "/HTML[1]/LINK[1]";
        int start = XPathHelper.getXPathLocation((String)html, (String)xpath);
        int end = XPathHelper.getCloseElementLocation((String)html, (String)xpath);
        Assert.assertEquals((long)6L, (long)start);
        Assert.assertEquals((long)22L, (long)end);
    }

    @Test
    public void formatXPath() {
        MatcherAssert.assertThat((Object)XPathHelper.formatXPath((String)"//ul/a"), (Matcher)Is.is((Object)"//UL/A"));
        MatcherAssert.assertThat((Object)XPathHelper.formatXPath((String)"/div//span"), (Matcher)Is.is((Object)"/DIV//SPAN"));
        MatcherAssert.assertThat((Object)XPathHelper.formatXPath((String)"//ul[@CLASS=\"Test\"]"), (Matcher)Is.is((Object)"//UL[@class=\"Test\"]"));
        MatcherAssert.assertThat((Object)XPathHelper.formatXPath((String)"//ul[@CLASS=\"Test\"]/a"), (Matcher)Is.is((Object)"//UL[@class=\"Test\"]/A"));
    }

    @Test
    public void formatXpathWithDoubleSlashes() {
        String xpath = "//div[@id='dontClick']//a";
        MatcherAssert.assertThat((Object)XPathHelper.formatXPath((String)xpath), (Matcher)Is.is((Object)"//DIV[@id='dontClick']//A"));
    }

    @Test
    public void formatXPathAxes() {
        String xPath = "//ancestor-or-self::div[@CLASS,'foo']";
        Assert.assertEquals((Object)"//ancestor-or-self::DIV[@class,'foo']", (Object)XPathHelper.formatXPath((String)xPath));
    }

    @Test
    public void getLastElementOfXPath() {
        String xPath = "/HTML/BODY/DIV/UL/LI[@class=\"Test\"]";
        Assert.assertEquals((Object)"LI", (Object)XPathHelper.getLastElementXPath((String)xPath));
    }

    @Test
    public void stripXPathToElement() {
        String xPath = "/HTML/BODY/DIV/UL/LI[@class=\"Test\"]";
        Assert.assertEquals((Object)"/HTML/BODY/DIV/UL/LI", (Object)XPathHelper.stripXPathToElement((String)xPath));
    }

    @Test
    public void useTextSelector() {
        String xPath = "//A[text()='add new']";
        String html = "<HTML xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\"><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n\t<META content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\">\n\t<META content=\"PHP-Addressbook\" name=\"Description\">\n\t<META content=\"\" name=\"Keywords\">\n\n\t<STYLE type=\"text/css\">\n\t\t\n    body {background-image:url('./skins/header-blue.jpg');background-repeat:repeat-x;background-position:top left;}\n    table#maintable th {text-align:center;border:1px solid #ccc;font-size:12px;background:#739fce;color:#fff;}\n    table#birthdays th {color:#fff;background:#739fce;margin:25px;border:1px solid #ccc;}\n\t\ttable#maintable th a {color:#fff;}\nbody,#footer,ul {margin:0;padding:0;}\nbody,p,td,h1,h2,a,a:hover {font-family:Arial,Helvetica,sans-serif;font-size:12px}\nh1 {font-size:18px}\nh2 {font-size:14px}\na {color:#036}\na:hover {color:#06C;text-decoration:none}\nimg {border:0;}\ntextarea {font-family:Arial,Helvetica,sans-serif;font-size:10pt}\n\n#container {margin:0 auto;width:780px;border:0}\n#top{color:#fff;margin:5px 0 0;height:20px;text-align:right;}\n#header {height:80px;}\n#header h1 {display:none;}\n\n#nav {margin:0 0 20px;height:25px;width:770px;float:left;border:0;display:inline;}\n#nav ul li a {color:#fff;padding:0 4px;}\n#nav ul li img {display:none;}\n\n#content {margin:20px 0 0;width:780px;}\n#footer {margin:45px 0 0;padding:20px 0;clear:both;}\n\nul {list-style:none;}\nul li {display:inline;}\n#footer ul li {display:block;}\n\nlabel {margin-right:0.5em;width:10em;float:left;text-align:left;display:block;}\n\n#search-az {text-align:center;padding:2px;}\n#a-z a {font-size:75%;} \n\n.odd {background:#e5e5e5;}\n.even {background:#f3f3f3;}\n\n#right,.right {float:right;}\n#left,.left {float:left;}\n.clear {clear:both;}\n\n.msgbox {padding:16px;border:1px solid #ccc;background:#fff4b4;width:60%;font-weight:700;}\n.msgbox i {font-weight:400;}\n\ntable {width:100%;border:1px solid #ccc;border-collapse:collapse;}\ntable tr td {border:1px solid #ccc;padding:2px 1px}\ntable img,.center {text-align:center;}\ntable th {text-align:left;font-size:14px;padding:8px 4px;}\n\ntable#birthdays {border:0;}\n.tablespace td {border:0;}\n\n/* View.php */\ntable#view,table#view td {border:1px solid #000;border-collapse:collapse;}\ntable#view td {padding:5px;}\n\n/* Edit.php */\n#content input[type=text],#content textarea {width:220px; margin-bottom:3px;}\n#content input[type=text] {height:1,1em}\n// #content textarea {height:8em}\ninput.byear{width:4em !important;}\n\n/* Source Forge */\n#download {margin:0;width:180px;background:#63A624;color:#fff;border:1px solid #000;text-align:center;}\n#download a,#top a {color:#fff;}\n\n/* Login */\n#content input[name=user],input[name=pass] {width:150px; margin-bottom:3px;}\t</STYLE>\n\t<!--[if !IE]>-->\n\t<LINK href=\"iphone.css\" media=\"only screen and (max-device-width: 480px)\" rel=\"stylesheet\" type=\"text/css\">\n\t<!--<![endif]-->\n\t<META content=\"width=320; initial-scale=1.0; maximum-scale=1.0; user-scalable=0;\" name=\"viewport\">\n\n\n\t<LINK href=\"icons/font.png\" rel=\"icon\" type=\"image/png\">\n\t<TITLE>Address book</TITLE>  \t</HEAD><BODY>\n  \t\t<DIV id=\"container\">\n  \t\t\t<DIV id=\"top\"></DIV>\n        <DIV id=\"header\"><A href=\".\"><IMG alt=\"address book\" src=\"title.png\" title=\"address book\"></A></DIV>\n  \t\t\t<DIV id=\"nav\"></DIV>\n  \t\t\t<DIV id=\"content\">\n  \t      <FORM accept-charset=\"utf-8\" method=\"post\" name=\"LoginForm\">\n  \t         <LABEL>User:</LABEL><INPUT name=\"user\" tabindex=\"0\"><BR>\n  \t         <LABEL>Password:</LABEL><INPUT name=\"pass\" type=\"password\">\n  \t         <BR>\n  \t         <INPUT type=\"submit\" value=\"Login\">\n  \t         <BR>\n  \t         <BR>\n          </FORM>\n<!--  \t         \n  \t         <a href=\"../register\">Create account</a>\n  \t         | <a href=\"../register\">Forgot password</a>  \t         \n  \t         <br><br>\n  \t         <br>\n  \t         <hr>\n  \t         <br><br>\n\n  \t      <form accept-charset=\"utf-8\" id=\"hLoginForm\" name=\"hLoginForm\" method=\"post\">\n  \t         <input name=\"user\" type=\"hidden\"/>\n  \t         <input name=\"pass\" type=\"hidden\"/>\n          </form>\n  \t         \n  \t         <a href=\"javascript:hLoginForm.user.value='Facebook';hLoginForm.submit();\"><img src=\"icons/facebook.png\"></a>\n  \t         <a href=\"javascript:hLoginForm.user.value='Google';hLoginForm.submit();\"><img src=\"icons/google.png\"></a>\n  \t         <a href=\"javascript:hLoginForm.user.value='Yahoo';hLoginForm.submit();\"><img src=\"icons/yahoo.png\"></a>\n  \t         <a href=\"javascript:hLoginForm.user.value='Live';hLoginForm.submit();\"><img src=\"icons/microsoft.png\"></a>\n  \t         <br><br><br>\n-->\n  \n        </DIV></DIV></BODY></HTML>";
        try {
            NodeList matches = XPathHelper.evaluateXpathExpression((String)html, (String)xPath);
            System.out.println(matches.getLength());
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testXpathForClickables() throws XPathExpressionException, IOException {
        String html = "<html><body><div evlist=true></div><a></a></body></html>";
        NodeList nodes = XPathHelper.evaluateXpathExpression((String)html, (String)"//*[@evlist]");
        System.out.println(nodes.getLength());
    }
}

