/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.util;

import com.crawljax.util.DomUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class XmlUnitDifferenceTest {
    @Test
    public void testEmptyDOMs() {
        String left = "";
        String right = "";
        List l = DomUtils.getDifferences((String)left, (String)right);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testSameIdenticalDOMs() {
        String left = "<abc></abc>";
        String right = "<abc></abc>";
        List l = DomUtils.getDifferences((String)left, (String)right);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testSameDOMsAttributesSame() {
        String left = "<abc><def value='bla'/></abc>";
        String right = "<abc><def value='bla'/></abc>";
        List l = DomUtils.getDifferences((String)left, (String)right);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testSameDOMsAttributesFiltered() {
        String left = "<abc><def value='bla123'/></abc>";
        String right = "<abc><def value='bla'/></abc>";
        List l = DomUtils.getDifferences((String)left, (String)right, (List)Lists.newArrayList((Object[])new String[]{"value"}));
        Assert.assertEquals((long)0L, (long)l.size());
    }
}

