/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.core;

import com.assertthat.selenium_shutterbug.core.ElementSnapshot;
import com.assertthat.selenium_shutterbug.core.PageSnapshot;
import com.assertthat.selenium_shutterbug.utils.web.Browser;
import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Shutterbug {
    private static final int DEFAULT_SCROLL_TIMEOUT = 100;

    public static PageSnapshot shootPage(WebDriver driver) {
        return Shutterbug.shootPage(driver, false);
    }

    public static PageSnapshot shootPage(WebDriver driver, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        PageSnapshot pageScreenshot = new PageSnapshot(driver, browser.getDevicePixelRatio());
        pageScreenshot.setImage(browser.takeScreenshot());
        return pageScreenshot;
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll) {
        return Shutterbug.shootPage(driver, scroll, 100);
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll, int scrollTimeout) {
        return Shutterbug.shootPage(driver, scroll, scrollTimeout, false);
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll, boolean useDevicePixelRatio) {
        return Shutterbug.shootPage(driver, scroll, 0, useDevicePixelRatio);
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll, int scrollTimeout, boolean useDevicePixelRatio) {
        Browser browser = scroll.equals((Object)ScrollStrategy.WHOLE_PAGE_CHROME) ? new Browser(driver, true) : new Browser(driver, useDevicePixelRatio);
        browser.setScrollTimeout(scrollTimeout);
        PageSnapshot pageScreenshot = new PageSnapshot(driver, browser.getDevicePixelRatio());
        switch (scroll) {
            case HORIZONTALLY: {
                pageScreenshot.setImage(browser.takeScreenshotScrollHorizontally());
                break;
            }
            case VERTICALLY: {
                pageScreenshot.setImage(browser.takeScreenshotScrollVertically());
                break;
            }
            case BOTH_DIRECTIONS: {
                pageScreenshot.setImage(browser.takeScreenshotEntirePage());
                break;
            }
            case WHOLE_PAGE_CHROME: {
                pageScreenshot.setImage(browser.takeScreenshotEntirePageUsingChromeCommand());
            }
        }
        return pageScreenshot;
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element) {
        return Shutterbug.shootElement(driver, element, false);
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        ElementSnapshot elementSnapshot = new ElementSnapshot(driver, browser.getDevicePixelRatio());
        browser.scrollToElement(element);
        elementSnapshot.setImage(browser.takeScreenshot(), browser.getBoundingClientRect(element));
        return elementSnapshot;
    }
}

