/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.leptonica;

import java.nio.FloatBuffer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.leptonica.FPIX;
import org.bytedeco.leptonica.global.leptonica;

@Properties(inherit={org.bytedeco.leptonica.presets.leptonica.class})
public abstract class AbstractFPIX
extends Pointer
implements Indexable {
    public AbstractFPIX(Pointer p) {
        super(p);
    }

    public static FPIX create(int width, int height) {
        FPIX p = leptonica.fpixCreate(width, height);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static FPIX createTemplate(FPIX fpixs) {
        FPIX p = leptonica.fpixCreateTemplate(fpixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public FPIX clone() {
        FPIX p = new FPIX(leptonica.fpixClone((FPIX)this));
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public FloatBuffer createBuffer() {
        return this.createBuffer(0);
    }

    public FloatBuffer createBuffer(int index) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        leptonica.fpixGetDimensions((FPIX)this, w, h);
        int wpl = leptonica.fpixGetWpl((FPIX)this);
        FloatPointer data = new FloatPointer((Pointer)leptonica.fpixGetData((FPIX)this)).position((long)index).capacity((long)(h[0] * wpl));
        return data.asBuffer();
    }

    public FloatIndexer createIndexer() {
        return this.createIndexer(true);
    }

    public FloatIndexer createIndexer(boolean direct) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        leptonica.fpixGetDimensions((FPIX)this, w, h);
        int wpl = leptonica.fpixGetWpl((FPIX)this);
        long[] sizes = new long[]{h[0], w[0], wpl / w[0]};
        long[] strides = new long[]{wpl, wpl / w[0], 1L};
        FloatPointer data = new FloatPointer((Pointer)leptonica.fpixGetData((FPIX)this)).capacity((long)(h[0] * wpl));
        return FloatIndexer.create((FloatPointer)data, (long[])sizes, (long[])strides, (boolean)direct);
    }

    public void destroy() {
        this.deallocate();
    }

    protected static class DestroyDeallocator
    extends FPIX
    implements Pointer.Deallocator {
        DestroyDeallocator(FPIX p) {
            super(p);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            leptonica.fpixDestroy(this);
            this.setNull();
        }
    }
}

