/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ddf;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import shadeio.poi.ddf.EscherBSERecord;
import shadeio.poi.ddf.EscherBitmapBlip;
import shadeio.poi.ddf.EscherBlipRecord;
import shadeio.poi.ddf.EscherChildAnchorRecord;
import shadeio.poi.ddf.EscherClientAnchorRecord;
import shadeio.poi.ddf.EscherClientDataRecord;
import shadeio.poi.ddf.EscherContainerRecord;
import shadeio.poi.ddf.EscherDgRecord;
import shadeio.poi.ddf.EscherDggRecord;
import shadeio.poi.ddf.EscherMetafileBlip;
import shadeio.poi.ddf.EscherOptRecord;
import shadeio.poi.ddf.EscherRecord;
import shadeio.poi.ddf.EscherRecordFactory;
import shadeio.poi.ddf.EscherSpRecord;
import shadeio.poi.ddf.EscherSpgrRecord;
import shadeio.poi.ddf.EscherSplitMenuColorsRecord;
import shadeio.poi.ddf.EscherTertiaryOptRecord;
import shadeio.poi.ddf.EscherTextboxRecord;
import shadeio.poi.ddf.UnknownEscherRecord;
import shadeio.poi.util.LittleEndian;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class<?>[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherTertiaryOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map<Short, Constructor<? extends EscherRecord>> recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    @Override
    public EscherRecord createRecord(byte[] data, int offset) {
        EscherRecord escherRecord;
        short recordId;
        short options = LittleEndian.getShort(data, offset);
        if (DefaultEscherRecordFactory.isContainer(options, recordId = LittleEndian.getShort(data, offset + 2))) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(recordId);
            r.setOptions(options);
            return r;
        }
        if (recordId >= -4072 && recordId <= -3817) {
            EscherBlipRecord r = recordId == -4065 || recordId == -4067 || recordId == -4066 ? new EscherBitmapBlip() : (recordId == -4070 || recordId == -4069 || recordId == -4068 ? new EscherMetafileBlip() : new EscherBlipRecord());
            r.setRecordId(recordId);
            r.setOptions(options);
            return r;
        }
        Constructor<? extends EscherRecord> recordConstructor = recordsMap.get(recordId);
        if (recordConstructor == null) {
            return new UnknownEscherRecord();
        }
        try {
            escherRecord = recordConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new UnknownEscherRecord();
        }
        escherRecord.setRecordId(recordId);
        escherRecord.setOptions(options);
        return escherRecord;
    }

    protected static Map<Short, Constructor<? extends EscherRecord>> recordsToMap(Class<?>[] recClasses) {
        HashMap<Short, Constructor<? extends EscherRecord>> result = new HashMap<Short, Constructor<? extends EscherRecord>>();
        Class[] EMPTY_CLASS_ARRAY = new Class[]{};
        Class<?>[] classArray = recClasses;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor;
            short sid;
            Class<?> recClass;
            Class<?> recCls = recClass = classArray[i];
            try {
                sid = recCls.getField("RECORD_ID").getShort(null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            try {
                constructor = recCls.getConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            result.put(sid, constructor);
        }
        return result;
    }

    public static boolean isContainer(short options, short recordId) {
        if (recordId >= -4096 && recordId <= -4091) {
            return true;
        }
        if (recordId == -4083) {
            return false;
        }
        return (options & 0xF) == 15;
    }
}

