/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ddf;

import java.util.ArrayList;
import java.util.List;
import shadeio.poi.ddf.EscherArrayProperty;
import shadeio.poi.ddf.EscherBoolProperty;
import shadeio.poi.ddf.EscherComplexProperty;
import shadeio.poi.ddf.EscherProperties;
import shadeio.poi.ddf.EscherProperty;
import shadeio.poi.ddf.EscherRGBProperty;
import shadeio.poi.ddf.EscherShapePathProperty;
import shadeio.poi.ddf.EscherSimpleProperty;
import shadeio.poi.util.IOUtils;
import shadeio.poi.util.LittleEndian;

public final class EscherPropertyFactory {
    private static final int MAX_RECORD_LENGTH = 100000000;

    public List<EscherProperty> createProperties(byte[] data, int offset, short numProperties) {
        ArrayList<EscherProperty> results = new ArrayList<EscherProperty>();
        int pos = offset;
        for (int i = 0; i < numProperties; ++i) {
            EscherProperty ep;
            short propId = LittleEndian.getShort(data, pos);
            int propData = LittleEndian.getInt(data, pos + 2);
            short propNumber = (short)(propId & 0x3FFF);
            boolean isComplex = (propId & Short.MIN_VALUE) != 0;
            byte propertyType = EscherProperties.getPropertyType(propNumber);
            switch (propertyType) {
                case 1: {
                    ep = new EscherBoolProperty(propId, propData);
                    break;
                }
                case 2: {
                    ep = new EscherRGBProperty(propId, propData);
                    break;
                }
                case 3: {
                    ep = new EscherShapePathProperty(propId, propData);
                    break;
                }
                default: {
                    ep = !isComplex ? new EscherSimpleProperty(propId, propData) : (propertyType == 5 ? new EscherArrayProperty(propId, IOUtils.safelyAllocate(propData, 100000000)) : new EscherComplexProperty(propId, IOUtils.safelyAllocate(propData, 100000000)));
                }
            }
            results.add(ep);
            pos += 6;
        }
        for (EscherProperty p : results) {
            if (!(p instanceof EscherComplexProperty)) continue;
            if (p instanceof EscherArrayProperty) {
                pos += ((EscherArrayProperty)p).setArrayData(data, pos);
                continue;
            }
            int leftover = data.length - pos;
            byte[] complexData = ((EscherComplexProperty)p).getComplexData();
            if (leftover < complexData.length) {
                throw new IllegalStateException("Could not read complex escher property, length was " + complexData.length + ", but had only " + leftover + " bytes left");
            }
            System.arraycopy(data, pos, complexData, 0, complexData.length);
            pos += complexData.length;
        }
        return results;
    }
}

