/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.record;

import shadeio.poi.hssf.record.RecordInputStream;
import shadeio.poi.hssf.record.cont.ContinuableRecord;
import shadeio.poi.hssf.record.cont.ContinuableRecordOutput;
import shadeio.poi.util.StringUtil;

public final class StringRecord
extends ContinuableRecord {
    public static final short sid = 519;
    private boolean _is16bitUnicode;
    private String _text;

    public StringRecord() {
    }

    public StringRecord(RecordInputStream in) {
        int field_1_string_length = in.readUShort();
        this._is16bitUnicode = in.readByte() != 0;
        this._text = this._is16bitUnicode ? in.readUnicodeLEString(field_1_string_length) : in.readCompressedUnicode(field_1_string_length);
    }

    @Override
    protected void serialize(ContinuableRecordOutput out) {
        out.writeShort(this._text.length());
        out.writeStringData(this._text);
    }

    @Override
    public short getSid() {
        return 519;
    }

    public String getString() {
        return this._text;
    }

    public void setString(String string) {
        this._text = string;
        this._is16bitUnicode = StringUtil.hasMultibyte(string);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[STRING]\n");
        buffer.append("    .string            = ").append(this._text).append("\n");
        buffer.append("[/STRING]\n");
        return buffer.toString();
    }

    @Override
    public Object clone() {
        StringRecord rec = new StringRecord();
        rec._is16bitUnicode = this._is16bitUnicode;
        rec._text = this._text;
        return rec;
    }
}

